% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{setPrompt}
\alias{setPrompt}
\title{set R prompt with project name and R version}
\usage{
setPrompt(
  projectName = "unnamed",
  useColor = TRUE,
  projectColor = "yellow",
  bracketColor = "white",
  Rcolors = c("white", "white", "white"),
  PIDcolor = NA,
  promptColor = "white",
  usePid = TRUE,
  resetPrompt = FALSE,
  addEscape = NULL,
  updateOptions = TRUE,
  debug = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{projectName}{\code{character} string, default "unnamed", used as
a label to represent the project work.}

\item{useColor}{\code{logical} whether to define a color prompt if the
\code{crayon} package is installed.}

\item{projectColor, bracketColor, Rcolors, PIDcolor, promptColor}{\code{character}
colors used when \code{useColor==TRUE} and the \code{crayon} package
is installed:
\itemize{
\item \code{projectColor} colors the project name;
\item \code{bracketColor} colors the curly brackets around the project;
\item \code{Rcolors} can be a vector of 3 colors, colorizing "R",
the "-" divider, and the R version;
\item \code{PIDcolor} colors the PID when \code{usePid=TRUE}; and
\item \code{promptColor} colors the \code{">"} at the end of the prompt.
}}

\item{usePid}{\code{logical} whether to include the process ID in the prompt.
Including the PID is helpful for the rare occasion when a process is
hung and needs to be stopped directly.}

\item{resetPrompt}{\code{logical} whether to revert all changes to the prompt
back to the default R prompt, that is, no color and no projectName.}

\item{addEscape}{\code{logical} or \code{NULL} indicating whether to wrap color
encoding ANSI inside additional escape sequences. This change is
helpful for linux-based (readline-based) R consoles, by telling
the console not to count ANSI color control characters as visible
characters when determining word wrapping on the console. Note
that RStudio does not work well with this setting.
If you find that the word-wrap is incorrect in the R console, try
\code{addEscape=TRUE}. Apparently most versions of RStudio will already
adjust (and prevent) colorizing the prompt during editing, presumably
to sidestep the problem of calculating the correct character length.
By default when \code{addEscape} is \code{NULL}, it checks whether environmental
variable \code{RSTUDIO} equals \code{"1"} (running inside RStudio) then sets
\code{addEscape=FALSE}; otherwise it defines \code{addEscape=TRUE}.
In most cases for commandline prompts, \code{addEscape=TRUE} is helpful
and not problematic.}

\item{updateOptions}{\code{logical} whether to update the user \code{options()}
with \code{options(prompt="...")}, default TRUE.}

\item{debug}{\code{logical} indicating whether to print the ANSI control
character output for the full prompt, for visual review.}

\item{verbose}{\code{logical} whether to print verbose output.}

\item{...}{additional parameters are passed to \code{make_styles()} which is
only relevant with the argument \code{useColor=TRUE}.}
}
\value{
\code{list} named \code{"prompt"}, suitable to use in \code{options()}
with the recommended prompt.
When \code{updateOptions=FALSE} use: \code{options(setPrompt("projectName"))}
}
\description{
set R prompt with project name and R version
}
\details{
This function sets a simple, colorized R prompt with useful
information:
\itemize{
\item \code{projectName}
\item R version, major and minor included
\item Process ID (PID)
}

The prompt is defined in \code{options("prompt")}.
\subsection{Where Am I?}{

It is useful for the question: "What version of R?"
In rare cases, multiple R versions can be active at once (!), see
the \code{rig} package for this exciting capability.
}

\subsection{What Am I Doing?}{

The core question addressed is : "What am I working on?"
The project name is especially useful when working
with multiple active R sessions.
}

\subsection{How Do I Stop This Thing?}{

It may also be useful for the question "How do I stop this thing",
by returning the Process ID to be used to kill a long-running process
without fear of killing the \strong{wrong} long-running process.
}

\subsection{Can It Have Color?}{

Then of course, meeting the above requirements, at least make it pretty.
}

\subsection{Word-Wrap Gone Awry}{

A color-encoded prompt may sometimes interfere
with word-wrapping on the R console.
A long line may wrap prematurely
before reaching the right edge of the screen.
There are two frequent causes of this issue:
\enumerate{
\item \code{options("width")} is sometimes defined too narrow for the
screen. When resizing the console, this option should be updated,
and sometimes this update fails. To fix, either resize the window
briefly again, or define \code{options("width")} manually.
(Or debug the reason that this option is not being updated.)
\item The terminal \code{locale} is sometimes mismatched with the terminal,
usually caused by a layer of terminal emulation which is not
compatible with ANSI color codes, or ANSI escape codes.
\itemize{
\item Some examples: 'PuTTY' on 'Windows', GNU 'screen', 'tmux'.
\item Check \code{Sys.env("LC_ALL")}. The most common results are
\code{"C"} for generic C-type output, or a Unicode/UTF-8 locale such as
\code{"en_US.UTF-8"} ('enUS' is English-USA in this context).
In general, Unicode/UTF-8 is recommended, with benefit that
it more readily displays other Unicode characters.
However, sometimes the terminal environment (PuTTY or iTerm)
is expecting one locale, but is receiving another. Either
switching the terminal expected locale, or the R console locale,
may resolve the mismatch.
}
}

R uses 'readline' for unix-like systems by default, and
issues related to using color prompt are handled at that level.

The 'readline' library allows escaping ANSI color characters so they
do not contribute to the estimated line width, and these codes are
used in \code{setPrompt()}.

The final workaround is \code{useColor=FALSE}, but that would be a sad
outcome.
}
}
\examples{
setPrompt("jamba")

setPrompt("jamba", projectColor="purple");

setPrompt("jamba", usePid=FALSE);

setPrompt(resetPrompt=TRUE);

}
\seealso{
Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()}
}
\concept{jam practical functions}
