% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colors-hsl.R
\name{col2hsl}
\alias{col2hsl}
\title{convert R color to HSL color matrix}
\usage{
col2hsl(x, ...)
}
\arguments{
\item{x}{\code{character} vector with R compatible colors.}

\item{...}{additional arguments are ignored.}
}
\value{
\code{numeric} matrix of H, S, L color values.
}
\description{
convert R color to HSL color matrix
}
\details{
This function takes an R color and converts to an HSL matrix, using
the \code{farver} package \code{farver::decode_colour()}
the colorspace package, and \code{\link[colorspace]{RGB}} and
\code{\link[colorspace]{polarLUV}} functions. It is also used to
maintain alpha transparency, to enable interconversion via other
color manipulation functions as well.

When \code{model="hsl"} this function uses \code{farver::decode_colour()}
and bypasses \code{colorspace}. In future the \code{colorspace} dependency
will likely be removed in favor of using \code{farver}. In any event,
\code{model="hsl"} is equivalent to using \code{model="polarLUV"} and
\code{fixup=TRUE}, except that it should be much faster.
}
\examples{
x <- c("#FF000044", "#FF0000", "firebrick");
names(x) <- x;
showColors(x)
xhsl <- col2hsl(x)
xhsl

xhex <- hsl2col(xhsl)
showColors(list(x=x,
   xhex=xhex),
   groupCellnotes=FALSE)

withr::with_par(list("mfrow"=c(4, 4), "mar"=c(0.2, 1, 4, 1)), {

for (H in seq(from=0, to=360, length.out=17)[-17]) {
S <- 75;
Lseq <- seq(from=15, to=95, by=10);
hsl_gradient <- hsl2col(
   H=H,
   S=85,
   L=Lseq);
hcl_gradient <- hcl2col(
   H=H,
   C=85,
   L=Lseq);
names(hsl_gradient) <- Lseq;
names(hcl_gradient) <- Lseq;
showColors(xaxt="n",
   list(
      hsl=hsl_gradient,
      hcl=hcl_gradient),
   main=paste0("Hue: ", round(H),
      "\nSat: ", S,
      "\nLum: (as labeled)"),
   groupCellnotes=FALSE)
}
})

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
