% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccard.test.mca.R
\name{jaccard.test.mca}
\alias{jaccard.test.mca}
\title{Compute p-value using the Measure Concentration Algorithm}
\usage{
jaccard.test.mca(x, y, px = NULL, py = NULL, accuracy = 1e-05,
  error.type = "average", verbose = TRUE)
}
\arguments{
\item{x}{a binary vector (e.g., fingerprint)}

\item{y}{a binary vector (e.g., fingerprint)}

\item{px}{probability of successes in \code{x} (optional)}

\item{py}{probability of successes in \code{y} (optional)}

\item{accuracy}{an error bound on approximating a multinomial distribution}

\item{error.type}{an error type on approximating a multinomial distribution ("average", "upper", "lower")}

\item{verbose}{whether to print progress messages}
}
\value{
\code{jaccard.test.mca} returns a list consisting of
\item{statistics}{centered Jaccard/Tanimoto similarity coefficient}
\item{pvalue}{p-value}
\item{expectation}{expectation}
}
\description{
Compute statistical significance of Jaccard/Tanimoto similarity coefficients.
}
\examples{
set.seed(1234)
x = rbinom(100,1,.5)
y = rbinom(100,1,.5)
jaccard.test.mca(x,y,accuracy = 1e-05)
}
