% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_analytically.R
\name{solve_analytically}
\alias{solve_analytically}
\title{Analytically solve stable isotope box models}
\usage{
solve_analytically(IN, paths, to_DIGEST_csv = FALSE, return_results = FALSE)
}
\arguments{
\item{IN}{input data, edited by \code{\link{sim.single_run}} (list of dataframes)}

\item{paths}{paths object edited by \code{\link{sim.single_run}} (list of characters)}

\item{to_DIGEST_csv}{if TRUE, edits csv outputs to DIGEST directory \cr
Default is FALSE.}

\item{return_results}{if TRUE, results returned as a list of R objects. \cr
Default is FALSE.}
}
\value{
Analytically determined evolution of stable isotope compositions
in all boxes over the run duration as specified in INPUT file. \cr \cr

Run outputs are stored in a temporary directory and not exported by \code{\link{solve_numerically}}.
\cr \cr
The outputs of the run are stored in the rds output file in the SERIES directory
with the following file name structure:  \cr
\strong{\emph{SERIES_ID + RUN_n.rds}}
}
\description{
An analytical solver of the system of ordinary differential \cr
equations (ODES) of stable isotope ratios of element X in all boxes. \cr
Not intended for manual use. \cr
The analytical solver finds the eigenvalues and eigenvectors of the ODES. \cr
It determines the set of analytical solutions that describes
the evolution of isotope ratios in each box over time.
}
\section{Optional csv outputs to the DIGEST folder are as follows}{

\enumerate{
\item OUT data file with initial and final size and delta values in all boxes. \cr
(file name structure: \strong{\emph{out_1_A_OUT + SERIES_ID + RUN_n + .csv}})
\item ODE_SOLNs data file summarizing outputs of the analytical solutions of the ODES  \cr
(eigenvalues, eigenvectors, relaxation times, constants according to initial conditions).  \cr
(file name structure: \strong{\emph{out_2_A_ODE_SOLNs + SERIES_ID + RUN_n + .csv}})
\item evD data file of the evolution with time of the delta values in all boxes.  \cr
(file name structure: \strong{\emph{out_3_A_evD + SERIES_ID + RUN_n + .csv}})
}
}

