% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R, R/allGenerics.R
\docType{class}
\name{ISA-class}
\alias{ISA-class}
\alias{ISA}
\alias{initialize,ISA-method}
\alias{ISA-initialize}
\title{S4 Class ISA, initialization method}
\usage{
\S4method{initialize}{ISA}(.Object, path)
}
\arguments{
\item{.Object}{character, name of the object of class \linkS4class{ISA} to
be initialized}

\item{path}{length-one character vector containing the path to the ISA-Tab
files of the dataset.}
}
\description{
An S4 class to store information from an ISA-Tab data set, including an
investigation file, one or more study files, and one or more assay files for
each study file.

When creating a new object of class \linkS4class{ISA} via:
\code{object <- new(Class = "ISA", path)}, the function
\code{initialize(.Object, path)} is called to initialize and create the
actual object. The \code{initialize-method} is seldomly used as a function
itself.
}
\section{Slots}{

\describe{
\item{\code{path}}{A length-one character vector containing the path to the ISA-Tab
dataset.}

\item{\code{iFileName}}{A length-one character vector containing the investigation
filename (by definition starting with \strong{i_} and ending at \strong{.txt}).}

\item{\code{oSR}}{A data.frame containing the "ONTOLOGY SOURCE REFERENCE" section of
the investigation file.}

\item{\code{invest}}{A data.frame containing the "INVESTIGATION" section of
the investigation file.}

\item{\code{iPubs}}{A data.frame containing the "INVESTIGATION PUBLICATIONS" section
of the investigation file.}

\item{\code{iContacts}}{A data.frame containing the "INVESTIGATION CONTACTS" section
of the investigation file.}

\item{\code{study}}{A list of data.frames containing the "STUDY" sections of the
investigation file. Each study has its own section and the study identifier
is used to name each element in the list.}

\item{\code{sDD}}{A list of data.frames containing the "STUDY DESIGN DESCRIPTORS"
sections of the investigation file. Each study has its own section and the
study identifier is used to name each element in the list.}

\item{\code{sPubs}}{A list of data.frames containing the "STUDY PUBLICATIONS"
sections of the investigation file. Each study has its own section and the
study identifier is used to name each element in the list.}

\item{\code{sFacts}}{A list of data.frames containing the "STUDY FACTORS" sections of
the investigation file. Each study has its own section and the study
identifier is used to name each element in the list.}

\item{\code{sAssays}}{A list of data.frames containing the "STUDY ASSAYS" sections of
the investigation file. Each study has its own section and the study
identifier is used to name each element in the list.}

\item{\code{sProts}}{A list of data.frames containing the "STUDY PROTOCOLS" sections
of the investigation file. Each study has its own section and he study
identifier is used to name each element in the list.}

\item{\code{sContacts}}{A list of data.frames containing the "STUDY CONTACTS"
sections of the investigation file. Each study has its own section and the
study identifier is used to name each element in the list.}

\item{\code{sFiles}}{A list of data.frames containing the "Study Files", containing
the contents of the Study Table files belonging to the studies in the
investigation. Each study has one Study Table file.}

\item{\code{aFiles}}{A list of data.frames containing the "Assay Files", containing
the contents of the Assay Table files belonging to the studies in the
investigation. Each study can have multiple Assay Table files. Each element
of the list is named by the Assay File Name.}
}}

\keyword{classes}
