% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params_resolve_missing.R
\name{resolve_missing}
\alias{resolve_missing}
\title{Resolve missing values in function parameters and check consistency}
\usage{
resolve_missing(
  ...,
  .env = rlang::caller_env(),
  .eval_null = TRUE,
  .error = NULL
)
}
\arguments{
\item{...}{either a set of relationships as a list of \code{x=y+z} expressions}

\item{.env}{the environment to check in (optional - defaults to \code{caller_env()})}

\item{.eval_null}{The default behaviour (when this option is \code{TRUE})
considers missing values to be are either not given, given explicitly as
\code{NULL} or given as a \code{NULL} default value. Sometimes we need to consider
\code{NULL} values differently to missing values. If this is set to \code{FALSE} only
strictly missing values are resolved, and explicit \code{NULL} values left as
is.}

\item{.error}{a glue specification defining the error message. This can use
parameters \code{.missing}, \code{.constraints}, \code{.present} and \code{.call} to construct
an error message. If \code{NULL} a default message is provided that is generally
sufficient.}
}
\value{
nothing. Alters the \code{.env} environment to fill in missing values or
throws an informative error
}
\description{
Uses relationships between parameters to iteratively fill in missing values.
It is possible to specify an inconsistent set of rules or data in which case
the resulting values will be picked up and an error thrown.
}
\examples{
# missing variables left with no default value in function definition
testfn = function(pos, neg, n) {
  resolve_missing(pos=n-neg, neg=n-pos, n=pos+neg)
  return(tibble::tibble(pos=pos,neg=neg,n=n))
}

testfn(pos=1:4, neg = 4:1)
testfn(neg=1:4, n = 10:7)

try(testfn())

# not enough info to infer the missing variables
try(testfn(neg=1:4))

# the parameters given are inconsistent with the relationships defined.
try(testfn(pos=2, neg=1, n=4))
}
\concept{parameter_checks}
