% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputFunctions.R
\name{igToGrViz}
\alias{igToGrViz}
\title{Exports Interaction graph to a GraphViz file}
\usage{
igToGrViz(ig, path = "", fName = "InteractionGraph")
}
\arguments{
\item{ig}{Interaction graph}

\item{path}{The folder in which to write the GraphViz file;}

\item{fName}{The name of the file to be created; "InteractionGraph" by
default}
}
\value{
Writes the \code{ig} interaction graph to a GraphViz \code{.gv} file
  to the folder specified in the \code{path}
}
\description{
Exports Interaction graph to a GraphViz file
}
\examples{
#create temp dir path with slashes
myDir <- gsub("\\\\\\\\", "/", tempdir())

#create interaction graph
g <- interactionGraph(golf, "Play", intNo = 10)

#write to 'graphviz' file
igToGrViz(g, path = myDir, fName = "MyGraph")
}
