% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{evaluate_effect_single_state}
\alias{evaluate_effect_single_state}
\alias{evaluate_effect_single_state.bru_mapper}
\alias{evaluate_effect_single_state.bm_list}
\alias{evaluate_effect_single_state.bru_comp_list}
\title{Evaluate a component effect}
\usage{
evaluate_effect_single_state(...)

\method{evaluate_effect_single_state}{bru_mapper}(component, input, state, ..., label = NULL)

\method{evaluate_effect_single_state}{bm_list}(components, input, state, ...)

\method{evaluate_effect_single_state}{bru_comp_list}(components, input, state, ...)
}
\arguments{
\item{...}{Optional additional parameters, e.g. \code{inla_f}. Normally unused.}

\item{component}{A \link{bru_mapper}, \link{bru_comp}, or
\link{bm_list}.}

\item{input}{Pre-evaluated component input}

\item{state}{Specification of one latent variable state:
\itemize{
\item \code{evaluate_effect_single_state.bru_mapper}:
A vector of the latent component state.
\item \verb{evaluate_effect_single_state.*_list}: list of named state vectors.
}}

\item{label}{Option label used for any warning messages, specifying the
affected component.}
}
\value{
\itemize{
\item \code{evaluate_effect_single_state.bm_list}: A list of
evaluated component effect values
}
}
\description{
Calculate latent component effects given some data and the state of the
component's internal random variables.
}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com} and
Finn Lindgren \email{finn.lindgren@gmail.com}
}
\keyword{internal}
