% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.inference.R
\name{bru_set_missing}
\alias{bru_set_missing}
\alias{bru_set_missing.bru}
\alias{bru_set_missing.bru_obs_list}
\alias{bru_set_missing.bru_obs}
\title{Set missing values in observation models}
\usage{
bru_set_missing(object, keep = FALSE, ...)

\method{bru_set_missing}{bru}(object, keep = FALSE, ...)

\method{bru_set_missing}{bru_obs_list}(object, keep = FALSE, ...)

\method{bru_set_missing}{bru_obs}(object, keep = FALSE, ...)
}
\arguments{
\item{object}{A \code{bru}, \code{bru_obs} or \code{bru_obs_list} object}

\item{keep}{For \code{bru_obs}, a single logical or an integer vector;
If \code{TRUE}, keep all the response data, if \code{FALSE} (default),
set all of it to \code{NA}. An integer vector determines which elements
to keep (for positive values) or to set as missing (negative values).

For \code{bru} and \code{bru_obs_list}, a logical scalar or vector, or a list, see
Details.}

\item{\dots}{Additional arguments passed on to the \code{bru_obs} method.
Currently unused.}
}
\description{
Set all or parts of the observation model response data
to \code{NA}, for example for use in cross validation (with \code{\link[=bru_rerun]{bru_rerun()}})
or prior sampling (with \code{\link[=bru_rerun]{bru_rerun()}} and \code{\link[=generate]{generate()}}).
}
\details{
For \code{bru} and \code{bru_obs_list},
\itemize{
\item{\code{keep} must be either a single logical, which is expanded to a list,}
\item{a logical vector, which is converted to a list,}
\item{an unnamed list of the same length as the number of observation
models, with elements compatible with the \code{bru_obs} method, or}
\item{a named list with elements compatible with the \code{bru_obs} method,
and only the named \code{bro_obs} models are acted upon, i.e. the elements
not present in the list are treated as \code{keep = TRUE}.}
}

E.g.: \code{keep = list(b = FALSE)} sets all observations in model \code{b} to missing,
and does not change model \code{a}.

E.g.: \code{keep = list(a = 1:4, b = -(3:5))} keeps only observations \code{1:4} of
model \code{a}, marking the rest as missing, and sets observations \code{3:5} of model
\code{b} to missing.
}
\examples{
obs <- c(
  A = bru_obs(y_A ~ ., data = data.frame(y_A = 1:6)),
  B = bru_obs(y_B ~ ., data = data.frame(y_B = 11:15))
)
bru_response_size(obs)
lapply(
  bru_set_missing(obs, keep = FALSE),
  function(x) {
    x[["response_data"]][["BRU_response"]]
  }
)
lapply(
  bru_set_missing(obs, keep = list(B = FALSE)),
  function(x) {
    x[["response_data"]][["BRU_response"]]
  }
)
lapply(
  bru_set_missing(obs, keep = list(1:4, -(3:5))),
  function(x) {
    x[["response_data"]][["BRU_response"]]
  }
)
}
