% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{bru_fill_missing}
\alias{bru_fill_missing}
\title{Fill in missing values in Spatial grids}
\usage{
bru_fill_missing(
  data,
  where,
  values,
  layer = NULL,
  selector = NULL,
  batch_size = deprecated()
)
}
\arguments{
\item{data}{A SpatialPointsDataFrame, SpatialPixelsDataFrame,
SpatialGridDataFrame, SpatRaster, Raster, or sf object
containing data to use for filling}

\item{where}{A, matrix, data.frame, or SpatialPoints or
SpatialPointsDataFrame, or sf object, containing the locations of the
evaluated values}

\item{values}{A vector of values to be filled in where \code{is.na(values)} is
\code{TRUE}}

\item{layer, selector}{Specifies what data column or columns from which to
extract data, see \code{\link[=bru_comp]{bru_comp()}} for details.}

\item{batch_size}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} due to improved
algorithm.
Size of nearest-neighbour calculation blocks, to limit the
memory and computational complexity.}
}
\value{
An infilled vector of values
}
\description{
Computes nearest-available-value imputation for missing values in space
}
\examples{
\dontrun{
if (bru_safe_inla()) {
  points <-
    sp::SpatialPointsDataFrame(
      matrix(1:6, 3, 2),
      data = data.frame(val = c(NA, NA, NA))
    )
  input_coord <- expand.grid(x = 0:7, y = 0:7)
  input <-
    sp::SpatialPixelsDataFrame(
      input_coord,
      data = data.frame(val = as.vector(input_coord$y))
    )
  points$val <- bru_fill_missing(input, points, points$val)
  print(points)

  # To fill in missing values in a grid:
  print(input$val[c(3, 30)])
  input$val[c(3, 30)] <- NA # Introduce missing values
  input$val <- bru_fill_missing(input, input, input$val)
  print(input$val[c(3, 30)])
}
}
}
