% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTrtRep.R
\name{getTrtRep}
\alias{getTrtRep}
\title{Calculate the Treatment Replication number}
\usage{
getTrtRep(design.df, trtTerm)
}
\arguments{
\item{design.df}{a data frame containing the experimental design. Requires
every column be a \code{\link{factor}}.}

\item{trtTerm}{a vector of character containing the labels of the treatment
terms in the model generated by the \code{\link{terms}}.}
}
\value{
A list containing two objects. The first object is a matrix called
\code{Rep} which contains the replication numbers, where the rows
correspond to each treatment combination and the columns correspond to the
treatment factors, i.e. the replication number with respect to each
treatment factor based on the treatment combination. The second object
called \code{Sca} which is a numeric vector for computing a coefficients of
the fixed effect parameter in EMS.
}
\description{
Calculate the replication number of every treatment term including the
interaction. This is used to compute the treatment efficiency factors.
}
\examples{

design1 <- local({ 
  Ani = as.factor(LETTERS[c(1,2,3,4,
                            5,6,7,8)])
  Trt = as.factor(letters[c(1,1,1,1,
                            2,2,2,2)])
  data.frame(Ani, Trt, stringsAsFactors = TRUE )
})

trt.str = "Trt"
  
fT = terms(as.formula(paste("~", trt.str, sep = "")), keep.order = TRUE)  #fixed terms

trtTerm = attr(fT,"term.labels")
effectsMatrix = attr(fT,"factor") 
		
getTrtRep(design1, trtTerm)   


}
\references{
John J, Williams E (1987). \emph{Cyclic and computer generated
Designs}. Second edition. Chapman & Hall.
}
\author{
Kevin Chang
}
