% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nin.R
\name{\%nin\%}
\alias{\%nin\%}
\title{Not-In Infix Operator}
\usage{
lhs \%nin\% rhs
}
\arguments{
\item{lhs}{The left-hand side, element(s) to be sought
in the rhs.}

\item{rhs}{The right-hand side; element(s) to be
compared against the lhs for possible membership.}
}
\value{
Returns a Boolean vector the length of lhs
conveying whether each element is \strong{un}represented
in the elements of rhs.
}
\description{
This tests whether the elements on the left-hand
side is \emph{not} within the elements on the right-hand
side. In effect, it is a cleaner, parsimonious way of
articulating \code{!(lhs \%in\% rhs)}. See the help
for \code{match} for additional documentation on matching.
}
\details{
Following the convention of \code{\%in\%}, which is actually
a call to \code{match}, \verb{\%nin\%} is defined as:
\code{match(lhs, rhs, nomatch = 0) == 0}. (In the case of
\code{\%in\%}, the final comparison is \verb{> 0}; as it is
looking for indices of the location of \code{lhs[i]} within
\code{rhs}, any positive match will be greater than 0 by
definition since 'R' is a 1-index language rather than
a 0-index language such as, e.g., Python).
}
\examples{
{
 
 "apple" \%nin\% c("carrot", "kiwi" ,"pear")

}
}
