% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/between.R
\name{\%btwn\%}
\alias{\%btwn\%}
\title{Between Infix Operator}
\usage{
lhs \%btwn\% rhs
}
\arguments{
\item{lhs}{The left-hand side, the value(s) to be compared.}

\item{rhs}{The right-hand side, the comparative range. Must
be a numeric vector of length 2 with the smaller value prior
to the larger value. Identical values can be passed.}
}
\value{
A Boolean vector the same length as the left-hand
side input.
}
\description{
Currently in R, if you want to test if a value is
between two others, you have to set it up in a
cumbersome manner: \code{X > Y & X < Z}. \verb{\%btwn\%} simplifies
the operation into a single call: \code{X \%btwn\% c(Y, Z)}.
}
\details{
By default, \verb{\%btwn\%} evaluates \emph{inclusively}. That is,
if the right-hand side is \code{c(1, 5)} and the left-hand
side is \code{c(1,5)}, it will evaluate as \verb{TRUE TRUE}. If
one wants to adjust this default behavior, they can
adjust the "infix.btwn" option to be either \emph{inclusive}
for the lower-bound ("["), \emph{exclusive} for the lower-
bound ("("), \emph{inclusive} for the upper-bound ("]"),
or \emph{exclusive} for the upper-bound (")"). To set an
inclusive lower-bound but exclusive upper-bound, for
example, you would do as follows:
\code{options(infixit.btwn = c("[", ")"))}. Additional
options allow you to set which date formats are
automatically parsed when comparing if one date is within
another (\code{infixit.btwn.datetimefmt}), and whether \verb{\%btwn\%}
will ignore \code{NA} values in the comparison or return them as
\code{FALSE} (\code{infixit.btwn.ignore_na})
}
\examples{
{
  13 \%btwn\% c(12.5, 15) #returns TRUE
}

}
