% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spline_model.R
\name{scan_spline_dof}
\alias{scan_spline_dof}
\title{Scan spline degrees of freedom}
\usage{
scan_spline_dof(
  reported,
  delay_dist,
  dof_grid,
  method = "bic",
  lam = 0,
  regularization_order = 2,
  reported_val = NULL,
  end_pad_size = 0,
  fisher_approx_cov = FALSE
)
}
\arguments{
\item{reported}{An integer vector of reported cases.}

\item{delay_dist}{A positive vector that sums to one, which describes the delay distribution.}

\item{dof_grid}{An integer vector of degrees of freedom for the spline basis.}

\item{method}{Metric to choose "best" dof: 'aic', 'bic', 'val'.
If method='val', reported_val must be non NULL and match reported size.}

\item{lam}{A fixed value for the beta parameter regularization strength.}

\item{regularization_order}{An integer (typically 0, 1, 2), indicating differencing order for L2 
regularization of spline parameters. Default is 2 for second derivative penalty.}

\item{reported_val}{Validation time series of equal size
to reported vector for use with 'val' method. Default is NULL.}

\item{end_pad_size}{And integer number of steps the spline is defined beyond the final 
observation.}

\item{fisher_approx_cov}{A flag to use either the Fisher Information (TRUE) or the Hessian (FALSE) to approx posterior covariance over parameters.}
}
\value{
A list of degree of freedom fit statistics: \itemize{
\item best_dof =  best degrees of freedom
\item dof_resdf = data frame of fit statistics (lambda, dof, aic, bic, val_lls, train_lls)}
}
\description{
This function holds the regularization parameter value fixed and scans spline degrees of freedom.
}
