#ifndef MCP_HPP
#define MCP_HPP

#include <RcppArmadillo.h>

namespace mcp {

    using namespace arma;

    double pen(const colvec& adjwt, const colvec& wt, double lambda) {
        size_t i;
        double df, gamma, res = 0.0;
        
        for (i = 0; i < wt.size(); i++) {
            df = fabs(wt[i] - adjwt[i]);
            gamma = (double) (wt[i] < 1.0) + (double) (wt[i] >= 1.0) * wt[i];
            if (df <= gamma * lambda) {
                res += lambda * df - 0.5 * df * df / gamma;
            }
            else {
                res += lambda * lambda * gamma * 0.5;
            }
        }        
        return res;
    }

    colvec penGrd(const colvec& adjwt, const colvec& wt, double lambda) {
        size_t i;
        double df, ad, gamma;
        colvec grd = sign(adjwt - wt);        
        for (i = 0; i < grd.size(); i++) {
            df = wt[i] - adjwt[i];
            ad = fabs(df);
            gamma = (double) (wt[i] < 1.0) + (double) (wt[i] >= 1.0) * wt[i];
            grd[i] *= (lambda - ad / gamma) * (double) (ad <= (gamma * lambda));
        }
        return grd;
    }

}

#endif // MCP_HPP
