% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylation_data.R
\docType{data}
\name{methylation_data}
\alias{methylation_data}
\title{Methylation array data for patients suffering from breast cancer}
\format{
A data frame with 205 rows and 10 columns.
\itemize{
  \item{Gene: The gene name.}
  \item{CpG: The CpG site associated to the gene.}
  \item{Patient1_M1: Methylation values from benign tissue from patient 1 for the corresponding CpG site.}
  \item{Patient2_M1: Methylation values from benign tissue from patient 2 for the corresponding CpG site.}
  \item{Patient3_M1: Methylation values from benign tissue from patient 3 for the corresponding CpG site.}
  \item{Patient4_M1: Methylation values from benign tissue from patient 4 for the corresponding CpG site.}
  \item{Patient1_M2: Methylation values from tumour tissue from patient 1 for the corresponding CpG site.}
  \item{Patient2_M2: Methylation values from tumour tissue from patient 2 for the corresponding CpG site.}
  \item{Patient3_M2: Methylation values from tumour tissue from patient 3 for the corresponding CpG site.}
  \item{Patient4_M2: Methylation values from tumour tissue from patient 4 for the corresponding CpG site.}
   }
}
\usage{
data(methylation_data)
}
\description{
A dataset containing simulated methylation array data for \eqn{C} CpG sites associated to \eqn{G} genes, from \eqn{R=2} sample types, collected from \eqn{N=4} patients.
}
\details{
The methylation array data is assumed to be from benign and tumour tissues.
The methylation data comprised of beta-valued methylation levels. The data needs to be transformed before applying idiffomix.
}
\seealso{
\code{\link{gene_expression_data}}

\code{\link{gene_chromosome_data}}
}
\keyword{datasets}
