% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Chapman_Kolmogorov.R
\name{ChapKolm_fwd_smooth}
\alias{ChapKolm_fwd_smooth}
\title{Chapman-Kolmogorov functions}
\usage{
ChapKolm_fwd_smooth(t, state, parms, fix_pars, subject)
}
\arguments{
\item{t}{Time at which the derivative is required}

\item{state}{Values for the state in which the system resides at time t
(current "estimate" of transition matrix P). 
Must be a vector of length n_states * n_states containing the stacked 
columns of P: c(P_11, P_21, ... P_(n_states 1), P_12, ..., P_(n_states n_states)).}

\item{parms}{Parameters to derive the derivative. For P-splines, this is 
a list of coefficients, with each list entry (corresponding to a transition number)
containing a vector of n_splines coefficients.}

\item{fix_pars}{A list of fixed parameters in the EM procedure}

\item{subject}{A subject identifier for risk-adjustment}
}
\value{
Returns the derivative of the transition probability matrix P(s,t)
 with respect to time (forward: t, backward: s) as a list.
}
\description{
Functions which can be used to solver the Chapman-Kolmogorov equations. 
The functions are in the form as expected by deSolve:ode().
}
\keyword{internal}
