% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_simulation_dist.R
\name{qtlnorm}
\alias{qtlnorm}
\title{Quantile Function of a Truncated Log-Normal Distribution}
\usage{
qtlnorm(q, meanlog = 0, sdlog = 1, upper_bound = Inf)
}
\arguments{
\item{q}{A numeric vector of probabilities for which to calculate the quantiles.}

\item{meanlog}{A numeric value representing the mean of the log-normal distribution on the log scale. Default is \code{0}.}

\item{sdlog}{A positive numeric value representing the standard deviation of the log-normal distribution on the log scale. Default is \code{1}.}

\item{upper_bound}{A positive numeric value indicating the upper truncation point. Default is \code{Inf} (no truncation).}
}
\value{
A numeric vector of quantiles corresponding to the given probabilities in \code{q}.
}
\description{
This function computes the quantiles of a truncated log-normal distribution for a given probability vector.
}
\examples{
# Calculate the 0.5 quantile of a truncated log-normal distribution
qtlnorm(0.5, meanlog = 0, sdlog = 1, upper_bound = 5)

}
