% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_simulation_dist.R
\name{ptweibull}
\alias{ptweibull}
\title{Cumulative Distribution Function of a Truncated Weibull Distribution}
\usage{
ptweibull(x, shape = 1, scale = 1, upper_bound = Inf)
}
\arguments{
\item{x}{A numeric vector at which to evaluate the CDF.}

\item{shape}{A positive numeric value representing the shape parameter of the Weibull distribution. Default is \code{1}.}

\item{scale}{A positive numeric value representing the scale parameter of the Weibull distribution. Default is \code{1}.}

\item{upper_bound}{A positive numeric value indicating the upper truncation point. Default is \code{Inf} (no truncation).}
}
\value{
A numeric vector of the CDF values of the truncated Weibull distribution at \code{x}.
}
\description{
This function computes the cumulative distribution function (CDF) of a truncated Weibull distribution
at a given point \code{x}.
}
\examples{
# Evaluate the CDF at x = 2 for a truncated Weibull distribution
ptweibull(2, shape = 2, scale = 1, upper_bound = 5)

}
