% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCustomColumns.R
\name{getCustomColumns}
\alias{getCustomColumns}
\title{Get the Custom Columns for SAG records}
\usage{
getCustomColumns(assessmentKey, ...)
}
\arguments{
\item{assessmentKey}{the unique identifier of the stock assessment}

\item{...}{arguments passed to \code{\link{sag_get}}.}
}
\value{
A data frame.
}
\description{
Get custom columns, such as alternative biomass series or Fproxy
  reference points for records in the SAG database.
}
\examples{
\dontrun{
assessmentKey <- findAssessmentKey("bli.27.5a14")
customs <- getCustomColumns(assessmentKey)
head(customs)
}
}
\seealso{
\code{\link{getSAG}} supports querying many years and quarters in one
  function call.

\code{\link{getListStocks}} and \code{\link{getFishStockReferencePoints}} get
  a list of stocks and reference points.

\code{\link{icesSAG-package}} gives an overview of the package.
}
\author{
Colin Millar.
}
