#' ICDPICR
#'
#' International Classification of Diseases Programs for Injury Categorization.
#' The ICDPICR package is an adaptation of the ICDPIC package originally written for Stata.
#' The original ICDPIC is a collection of Stata programs for injury categorization
#' and is available as a Stata download or online at \url{https://ideas.repec.org/c/boc/bocode/s457028.html}
#'
#' @section Version:
#'
#' ICDPICR Version 0.1.0 was adapted from the ICDPIC Version 3.0 Stata program,
#' especially to accommodate both ICD-9 and ICD-10 diagnosis codes. Some of the
#' functionality of the original Stata program was reduced in the interest of providing updates for
#' only the most useful elements of the original ICDPIC program, and some of this functionality
#' has been restored along with other features in the current ICDPICR Version 1.0.
#' ICDPICR is open source and all code is availble at \url{https://github.com/ablack3/icdpicr}.
#' Documentation can be found online at \url{https://ablack3.github.io/icdpicr/}.
#'
#'
#'
#' @section Description:
#' ICDPICR (International Classification of Diseases Programs for Injury Categorization in R)
#' is an R package currently consisting of a single function "cat_trauma" that performs
#' the same task that the "trauma" program does in the Stata version of ICDPIC.
#' The intention of these programs is to provide inexpensive methods for translating International
#' Classification of Diseases (ICD) diagnosis codes into standard injury
#' categories and/or scores.
#' The authors would appreciate suggestions or corrections from any user of the software.
#' Bug reports or feature requests may be submitted at \url{https://github.com/ablack3/icdpicr/issues}.
#' Publications of studies in which these programs or tables are used should cite the authors.
#'
#' @section Methods:
#' For each valid ICD-9-CM or ICD-10-CM injury diagnosis, ICDPICR is programmed to generate an approximate AIS
#' and body region, using the original AIS anatomic classification (as modified by Baker and colleagues) into
#' six body regions: Head and neck, face, chest, abdomen and pelvic contents, extremities and pelvic bones, and
#' general.  In addition, each code referring to a mechanism of injury is categorized as recommended or
#' proposed by the CDC. For each injured person, ICDPICR determines the maximal AIS in each body region
#' and overall, an Injury Severity Score (RISS), a regression-based prediction of mortality, and CDC mechanism/intent categories.
#'
#' Mapping of ICD-9-CM E-codes to CDC mechanism categories simply involved translation of the programming
#' code from Stata into R, using essentially the same table.  Mapping of ICD-10-CM codes to mechanism categories was
#' based on a similar table published by the CDC.
#'
#' The National Trauma Data Standard used by the ACS Trauma Quality Improvement Project (TQIP)
#' considers valid ICD-10-CM injury codes to be those in the
#' ranges S00-S99, T07, T14, T20-T28, and T30-32.  ICDPICR recognizes only these codes in the calculation
#' of injury severity from ICD-10-CM, and also requires that the codes have a decimal point in the fourth position
#' and the letter "A", "B", or "C" in the eighth position (indicating an initial encounter).
#' Mapping of ICD-10-CM codes to AIS severity may be performed in several ways, as described below.
#'
#' \strong{"ROCmax" mapping method for ICD-10-CM codes or basic ICD-10 codes:}
#' The ROCmax option in ICDPICR Version 1.0 allows the user to choose either TQIP or
#' National Inpatient Survey (NIS) as the reference database.  Ridge regression is used to
#' estimate the independent effect of each injury diagnosis on mortality.  If one of the ROCmax
#' options is chosen, a prediction of mortality for each subject (Pmort) is provided directly from
#' the regression, as well as an estimated Injury Severity Score (ISS). As in the earlier Stata
#' version of ICDPIC, a "New Injury Severity Score" (NISS) is now also calculated for all options.
#'
#'
#' \strong{"GEM" mapping method for ICD-10-CM codes:}
#' ICD-10-CM codes are first mapped to ICD-9-CM codes using the General Equivalency Mapping (GEM)
#' tables provided by the Centers for Medicare and Medicaid Services (CMS), and then those ICD-9-CM
#' codes are mapped to AIS using the table inherited from the Stata version of ICDPIC.
#' The user is given the option to ignore ICD-10-CM codes if desired.  Otherwise, if the GEM maps an
#' ICD-10-CM code to two or more ICD-9-CM codes associated with different severities, the user
#' is given the option whether to assign the greater or lesser of these severities
#' ("GEMmax" or "GEMmin").  When the GEM maps an ICD-10-CM code to two or more ICD-9-CM codes
#' associated with different AIS body regions, the verbal description of the ICD-10-CM code in the
#' GEM table is used to assign a body region.
#'
#' A GEM mapping method is necessary when injuries have been coded with ICD-9-CM codes only,
#' and may be preferable when they have been coded with a mix of ICD-9-CM and ICD-10-CM.
#'
#'
#'
#' For any of the mapping methods in ICDPICR, the maximum AIS Severity for each AIS body region
#' (MXAISBR1 ... MXAISBR6 in the output) is 0 if there are no valid injury codes for that body region.  It is
#' recorded as "missing" if there are valid codes for that body region, but their severity cannot be determined.
#' Otherwise, it is the maximum known severity (1 through 6) for that body region.  Maximum AIS Severity
#' (MAXAIS in the output data) is the maximum of (MXAISBR1 ... MXAISBR6); MAXAIS will thus be 0 if there is no
#' diagnosis code associated with an AIS severity.
#'
#' Injury Severity Score (RISS) is calculated according to the classic description of Baker and colleagues,
#' namely the sum of the squares of the three largest elements of (MXAISBR1 ... MXAISBR6).  The user can choose
#' whether to assign RISS=75 when any injury is assigned a severity of 6, or to reassign a severity of 5 to
#' these injuries and calculate RISS as above.  The first option, RISS = 75 when any severity = 6, is the default
#' in ICDPICR, since by definition an AIS severity of 6 should denote an injury that is uniformly fatal and
#' thus should rarely be found in hospital data.
#'
#'
#' @section Functions:
#' \strong{cat_trauma} provides various classifications and characterizations of trauma
#' based on ICD-9 or ICD-10 injury diagnosis codes. Details can be found in the help file for cat_trauma.
#'
#' @docType package
#' @name icdpicr
NULL
