% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surveys.R
\name{ibge_surveys}
\alias{ibge_surveys}
\title{List IBGE surveys with metadata}
\usage{
ibge_surveys(thematic_classifications = TRUE)
}
\arguments{
\item{thematic_classifications}{Logical. If \code{TRUE} (default), includes a
list-column \code{thematic_classifications} with the classification details
for each survey. Set to \code{FALSE} for a simpler flat tibble.}
}
\value{
A \link[tibble:tibble]{tibble} with columns:
\describe{
\item{id}{Survey code (e.g. \code{"SC"}, \code{"CD"})}
\item{name}{Survey name in Portuguese}
\item{name_en}{Survey name in English (may be \code{NA})}
\item{status}{Survey status: Ativa, Encerrada, etc.}
\item{category}{Conjuntural, Estrutural, or Especial}
\item{collection_frequency}{Data collection frequency (Mensal, Anual, etc.)}
\item{publication_frequency}{Publication frequency}
\item{thematic_classifications}{List-column of tibbles with thematic
classification details (name, domain, description). Only if
\code{thematic_classifications = TRUE}.}
}
}
\description{
Retrieves the full catalog of IBGE surveys (statistical operations) that
have associated metadata in the IBGE Metadata API, including status,
category, collection and publication frequency, and thematic classifications.
}
\details{
This function queries a \strong{different API} from the other \verb{ibge_*} functions.
While \code{ibge_aggregates()} and \code{ibge_metadata()} use the Aggregates API (v3),
this function uses the Metadata API (v2), which provides institutional and
methodological documentation about surveys.
}
\examples{
\dontrun{
# Full catalog
ibge_surveys()

# Flat table without classifications
ibge_surveys(thematic_classifications = FALSE)

# Filter active conjunctural surveys
library(dplyr)
ibge_surveys(thematic_classifications = FALSE) |>
  filter(status == "Ativa", category == "Conjuntural")
}

}
\seealso{
\code{\link[=ibge_survey_periods]{ibge_survey_periods()}}, \code{\link[=ibge_survey_metadata]{ibge_survey_metadata()}}
}
