% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_logiModel.R
\name{get_logiModel}
\alias{get_logiModel}
\title{Fit Logistic Regression Model}
\usage{
get_logiModel(data.sig, pred.value, levels = c("R", "N"), step = TRUE)
}
\arguments{
\item{data.sig}{A data frame where each row is a sample and each column is a pathway.}

\item{pred.value}{A numeric vector representing the response variable.}

\item{levels}{A character vector specifying the levels of the response variable (default: c("R", "N")).}

\item{step}{Logical. If TRUE, perform stepwise model selection (default: TRUE).}
}
\value{
A fitted logistic regression model.
}
\description{
This function fits a logistic regression model to the given data.
}
\details{
The function converts the response variable to a factor with specified levels and fits a logistic regression model using the glm function.
}
\examples{
data(data_sig, package = "iPRISM")
\donttest{
b <- get_logiModel(data.sig = data_sig, pred.value = pred_value, step = TRUE)
summary(b)
}
}
\keyword{classification}
\keyword{logistic}
\keyword{model}
\keyword{regression}
