% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inzdf.R
\name{inzdf}
\alias{inzdf}
\alias{inzdf.tbl_df}
\alias{inzdf.data.frame}
\alias{inzdf.SQLiteConnection}
\title{iNZight data frame object}
\usage{
inzdf(x, name, ...)

\method{inzdf}{tbl_df}(x, name, ...)

\method{inzdf}{data.frame}(x, name, ...)

\method{inzdf}{SQLiteConnection}(
  x,
  name = deparse(substitute(x)),
  schema = NULL,
  var_attrs = list(),
  dictionary = NULL,
  keep_con = FALSE,
  ...
)
}
\arguments{
\item{x}{a data.frame or db connection}

\item{name}{the name of the data}

\item{...}{additional arguments passed to methods}

\item{schema}{a list specifying the schema of the database (used for linking)}

\item{var_attrs}{nested list of variables attributes for each table > variable}

\item{dictionary}{an inzdict object}

\item{keep_con}{if `TRUE` data will remain in DB (use for very large data)}
}
\value{
an \code{inzdf} object
}
\description{
This object allows the data to be either a standard R \code{data.frame} or
a connection to a database.
}
\details{
TODO:
It is possible to specify a linking structure between multiple datasets,
and when variables are selected the dataset will be linked 'on-the-fly'.
This, when used with databases, will significantly reduce the size of data in memory.
}
