\name{plot_results}

\alias{plot_results}

\title{
Master Function for Plotting Hydrological Model Results
}

\description{
The function \code{plot_results} consolidates the plotting capabilities for 
hydrological model outputs, Pareto-optimal front solutions, and parameter 
sensitivity analyses. It calls three subordinate functions (\code{plot_out}, 
\code{plot_pof}, \code{plot_param}) to generate the required plots, offering 
a comprehensive visualization tool for model evaluation and optimization results. \cr

\bold{(*)}: When \code{do.png == TRUE}, graphics are written to disk. \cr
}

\usage{
plot_results(Results,
             model.out = NULL,
             analysis.period = NULL, 
             model.out.bcs = NULL, 
             bcs = NULL, 
             obs.var = NULL,
             dimensions = NULL, 
             obj.names = NULL,
             dates.cal = NULL, 
             dates.warmup = NULL, 
             var.names = NULL,
             var.units = NULL,
             xlim = NULL,
             ylim = NULL,
             digits = 4,
             col.band = "skyblue",
             col.bcs = "mediumblue",
             col.obs = "black",
             lwd = 0.75,
             pch.bcs = 15,
             pch.obs = 15,
             main = "study case #1",
             drty.out = "MOPSO.out",
             cex.pt.out = 0.25,
             cex.pt.pof = 1.25,
             cex.pt.param = 1, 
             cex.main = 1,
             cex.lab = 1,
             cex.axis = 1,
             do.png = FALSE,
             legend.obs = "Observation",
             legend.bcs = "Best compromise solution",
             legend.band = "Pareto front bands",
             pof = NULL,
             maxmin = NULL,
             obj.thr = NULL,
             pch.pof = 21,
             col.pof = "#f21b1b",
             legend.pof = c("Pareto-optimal front solutions", 
                            "Best compromise solution"),
             legend.param = NULL,
             col = NULL,
             col.param = NULL,
             col.lines = NULL,
             name.param = NULL,
             cex.leg = 1)
}
            
\arguments{
  \item{Results}{(\code{list}) \cr
    Object containing preprocessed hydrological results.
  }
  \item{model.out}{(\code{list} or \code{NULL}) \cr
    Output from the hydrological model used for evaluation.
  }
  \item{analysis.period}{(\code{character} or \code{NULL}) \cr
    Time period for analysis (e.g., "calibration" or "verification").
  }
  \item{model.out.bcs}{(\code{list} or \code{NULL}) \cr
    Model output representing the "Best Compromise Solution" (BCS).
  }
  \item{bcs}{(\code{matrix} or \code{NULL}) \cr
    Parameters or results corresponding to the best compromise solution (BCS).
  }
  \item{obs.var}{(\code{list} or \code{NULL}) \cr
    Observed variables to be compared against the model outputs.
  }
  \item{dimensions}{(\code{matrix} or \code{NULL}) \cr
    Dimensions of the modeled problem, typically indicating the number of 
    objectives and variables.
  }
  \item{obj.names}{(\code{character} or \code{NULL}) \cr
    Names of the objectives.
  }
  \item{dates.cal}{(\code{Date} or \code{NULL}) \cr
    Dates of the calibration period.
  }
  \item{dates.warmup}{(\code{Date} or \code{NULL}) \cr
    Dates of the model's warm-up period.
  }
  \item{var.names}{(\code{character} or \code{NULL}) \cr
    Names of the modeled and observed variables.
  }
  \item{var.units}{(\code{character} or \code{NULL}) \cr
    Units of the modeled and observed variables.
  }
  \item{xlim}{(\code{numeric} or \code{NULL}) \cr
    Limits for the x-axis in the plots.
  }
  \item{ylim}{(\code{numeric} or \code{NULL}) \cr
    Limits for the y-axis in the plots.
  }
  \item{digits}{(\code{integer}) \cr
    Number of digits to use for rounding values in plots and legends.
  }
  \item{col.band}{(\code{character}) \cr
    Color used for the model uncertainty bands in the plots.
  }
  \item{col.bcs}{(\code{character}) \cr
    Color used for the line representing the best compromise solution (BCS).
  }
  \item{col.obs}{(\code{character}) \cr
    Color used for the observed variable lines in the plots.
  }
  \item{lwd}{(\code{numeric}) \cr
    Line width used in the plots for model and observation lines.
  }
  \item{pch.bcs}{(\code{integer}) \cr
    Symbol type for points in the plot representing the best compromise 
    solution (BCS).
  }
  \item{pch.obs}{(\code{integer}) \cr
    Symbol type for points in the plot representing the observations.
  }
  \item{main}{(\code{character}) \cr
    Main title for the plot.
  }
  \item{drty.out}{(\code{character}) \cr
    Output directory where plots will be saved if specified to save as PNG files.
  }
  \item{cex.pt.out}{(\code{numeric}) \cr
    Size of points in the "out" plots.
  }
  \item{cex.pt.pof}{(\code{numeric}) \cr
    Size of points in the "pof" plots.
  }
  \item{cex.pt.param}{(\code{numeric}) \cr
    Size of points in the "param" plots.
  }
  \item{cex.main}{(\code{numeric}) \cr
    Size of the main title text in the plot.
  }
  \item{cex.lab}{(\code{numeric}) \cr
    Size of the axis label text in the plots.
  }
  \item{cex.axis}{(\code{numeric}) \cr
    Size of the axis values text in the plots.
  }
  \item{do.png}{(\code{logical}) \cr
    Boolean value indicating whether the plots should be saved as PNG files.
  }
  \item{legend.obs}{(\code{character}) \cr
    Legend text for observations.
  }
  \item{legend.bcs}{(\code{character}) \cr
    Legend text for the best compromise solution (BCS).
  }
  \item{legend.band}{(\code{character}) \cr
    Legend text for Pareto front bands.
  }
  \item{pof}{(\code{matrix} or \code{NULL}) \cr
    Dataset representing the filled Pareto-optimal front (POF) solutions.
  }
  \item{maxmin}{(\code{character} or \code{NULL}) \cr
    Indicator of whether objectives are to be maximized ("max") or minimized 
    ("min").
  }
  \item{obj.thr}{(\code{numeric} or \code{NULL}) \cr
    Objective thresholds.
  }
  \item{pch.pof}{(\code{integer}) \cr
    Symbol type for points in the plot representing the Pareto-optimal front 
    solutions.
  }
  \item{col.pof}{(\code{character}) \cr
    Color used for the points representing the Pareto-optimal front solutions 
    in the plots.
  }
  \item{legend.pof}{(\code{character}) \cr
    Legend text for the Pareto-optimal front and best compromise solution.
  }
  \item{legend.param}{(\code{character} or \code{NULL}) \cr
    Legend text for the parameters in the plots.
  }
  \item{col}{(\code{character} or \code{NULL}) \cr
    Colors used for points in the parameter dotty plots.
  }
  \item{col.param}{(\code{character} or \code{NULL}) \cr
    Specific colors for lines or points representing parameters in the 
    parameter boxplots.
  }
  \item{col.lines}{(\code{character} or \code{NULL}) \cr
    Specific colors for lines in the parameter boxplots.
  }
  \item{name.param}{(\code{character} or \code{NULL}) \cr
    Custom names for the parameters to be plotted.
  }
  \item{cex.leg}{(\code{numeric}) \cr
    Size of the legend text in the plots.
  }
}

\value{
No return value; generates plots as a side effect.
}

\author{
Rodrigo Marinao Rivas \email{ra.marinao.rivas@gmail.com}, 
Mauricio Zambrano-Bigiarini, \email{mzb.devel@gmail.com}
}

\seealso{
\code{\link{plot_out}}, \code{\link{plot_pof}}, \code{\link{plot_param}}
}


\keyword{hydrological model}
\keyword{multi-objective optimisation}
