% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html5.R
\name{link}
\alias{link}
\title{Generate the <link> HTML tag.}
\usage{
link(
  attr = NULL,
  separate = FALSE,
  collapse = "",
  formatted = html5_vars$formatted
)
}
\arguments{
\item{attr}{A named list or named vector, names are attribute names and values are attribute values.}

\item{separate}{TRUE/FALSE, If TRUE, returns separate tags for each item of attr if length of that item is greater than 1; if FALSE, returns one tag.}

\item{collapse}{A string. If NULL, returns a vector the same length as the longest item of attr, instead of one string.}

\item{formatted}{TRUE/FALSE, if TRUE, HTML will be generated with indents and new lines for readability at the cost of performance. Controlled by setting the environment variable html5_vars$formatted <- TRUE/FALSE}
}
\value{
A HTML tag string.
}
\description{
The <link> HTML element specifies relationships between the current document and an external resource. This element is most commonly used to link to CSS, but is also used to establish site icons (both "favicon" style icons and icons for the home screen and apps on mobile devices) among other things.
}
\details{
Learn more at \url{https://developer.mozilla.org/en-US/docs/Web/HTML/Element/link}.
}
\examples{
link(attr = list(class = "test"))
}
