% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marray.r, R/mmatrix.r, R/mvector.r
\name{marray}
\alias{marray}
\alias{mmatrix}
\alias{mvector}
\title{Creation of memory mapped objects}
\usage{
marray(
  datatype = c("double", "float", "integer", "short"),
  dim,
  filename,
  readonly
)

mmatrix(
  datatype = c("double", "float", "integer", "short"),
  nrow,
  ncol,
  filename,
  readonly
)

mvector(
  datatype = c("double", "float", "integer", "short"),
  length,
  filename,
  readonly
)
}
\arguments{
\item{datatype}{the data type}

\item{dim}{dimension of marray}

\item{filename}{(optional) path to file}

\item{readonly}{(optional) if \code{TRUE}, the object will be read-only.}

\item{nrow}{number of rows of mmatrix}

\item{ncol}{number of columns of mmatrix}

\item{length}{length of mvector}
}
\value{
a memory mapped object, of class 'mvector', 'mmatrix' or 'marray'
}
\description{
These functions create memory mapped vectors, matrices or arrays, 
possibly from an existing file. It is also possible to create objects in memory,
by passing the argument \code{filename = ""}.
}
\details{
Currently \code{datatype} can only be double, float, int, or short. Short will always be a 16 bits 
integer (int16_t).

If \code{filename} is missing, a temporary filename will be generated using \code{tempfile}.
If it is an empty string, the object will be created by allocating memory.
Otherwise, \code{filename} must be a valid path file; 
if the file exists, it will be opened (if its size is compatible with the dimension
of the object); if the file does not exist, it will be created.

If \code{readonly} is missing, it will be set to \code{TRUE} when opening an existing file, and
to \code{FALSE} when the file is created by the function.
}
\examples{
a <- mmatrix("float", 4, 3)
a[] <- 1:12
a[1,]

}
