% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{export_games}
\alias{export_games}
\title{Export games for a player}
\usage{
export_games(
  cl,
  username,
  max = 100,
  since = NULL,
  until = NULL,
  perfType = NULL,
  rated = NULL,
  opening = TRUE
)
}
\arguments{
\item{cl}{A \code{horsey_client}.}

\item{username}{Lichess username.}

\item{max}{Maximum number of games to request (default 100).}

\item{since}{Optional epoch milliseconds (inclusive).}

\item{until}{Optional epoch milliseconds (exclusive).}

\item{perfType}{Optional perf filter (e.g., "blitz", "rapid").}

\item{rated}{Optional logical filter.}

\item{opening}{If TRUE, ask Lichess to include opening info when available.}
}
\value{
A tibble with selected metadata columns and a \code{raw} list-column.
}
\description{
Downloads games from \verb{/api/games/user/\{username\}} and requests NDJSON.
Returns a tibble of commonly-used analysis fields, plus a \code{raw} list-column
containing each full game object as returned by the API.
}
