% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_count_top.R
\name{tar_count_top}
\alias{tar_count_top}
\title{Count Top Categories in a Factor}
\usage{
tar_count_top(df, var, n = 5)
}
\arguments{
\item{df}{A data frame containing the variable to be manipulated.}

\item{var}{The variable (unquoted) within the data frame.}

\item{n}{The number of top levels to keep before lumping others into 'Other'; default is 5.}
}
\value{
A dataframe showing the count of each level including 'Other' for all lumped lesser categories.
}
\description{
This function transforms the specified factor variable within a dataframe to lump all but the top n most frequent levels into an 'Other' category and then computes the count of each level.
}
\details{
This function leverages `dplyr` for data manipulation and `forcats` for managing factor levels. It is particularly useful in data summarization where the focus is on the most frequent categories.
}
\examples{
\donttest{
if(interactive()){
  data <- data.frame(color = c("red", "blue", "green", "blue", "blue", "red", "yellow", "red"))
  print(tar_count_top(data, color, n = 2))
 }
}
}
