% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{as_sf}
\alias{as_sf}
\title{Convert HexData to sf Object}
\usage{
as_sf(x, geometry = c("point", "polygon"), ...)
}
\arguments{
\item{x}{A HexData object}

\item{geometry}{Type of geometry: "point" (default) or "polygon"}

\item{...}{Additional arguments (ignored)}
}
\value{
An sf object
}
\description{
Converts a HexData object to an sf spatial features object. Can create
either point geometries (cell centers) or polygon geometries (cell boundaries).
}
\details{
For point geometry, cell centers (cell_cen_lon, cell_cen_lat) are used.
For polygon geometry, cell boundaries are computed using the grid specification.
}
\examples{
df <- data.frame(lon = c(0, 10, 20), lat = c(45, 50, 55))
result <- hexify(df, lon = "lon", lat = "lat", area_km2 = 1000)

# Get sf points
sf_pts <- as_sf(result)

# Get sf polygons
sf_poly <- as_sf(result, geometry = "polygon")
}
