% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heterog.R
\name{heterog}
\alias{heterog}
\title{Heterogeneity (rasters)}
\usage{
heterog(
  datastack,
  bandwidth = 0.3,
  tolerance = 5,
  nprocess = 1000,
  parallel = FALSE,
  ncores = 2,
  normalized = FALSE,
  method = "iter",
  dirds = "rds"
)
}
\arguments{
\item{datastack}{\code{SpatRaster} class. The input raster stack representing environmental variables.
Each layer in the stack corresponds to a different environmental variable, and the function calculates heterogeneity based on the variability across these layers.}

\item{bandwidth}{The bandwidth for the spatial weighting function.}

\item{tolerance}{The tolerance for spatial weight computation.}

\item{nprocess}{(Optional) The number of iterations for calculating the principal components. Default is set to 1000.}

\item{parallel}{(Optional) A logical value indicating whether to run the computation in parallel. If \code{TRUE}, multiple cores will be used for processing. Default is \code{FALSE}.}

\item{ncores}{(Optional) The number of cores to be used for parallel computation. Only applicable if \code{parallel} is set to \code{TRUE}. Default is 4.}

\item{normalized}{(Optional) A logical value indicating whether the input data should be normalized before performing GWPCA. Default is \code{FALSE}, meaning the data will not be normalized.
Take in account that core function performs correlation analysis in order to normalize the input variables.}

\item{method}{The method used for GWPCA computation. It can take one of the following values. \code{local} Performs GWPCA locally and will save each iteration on .rds files. Recommended for large-scale data sets.
\code{inter} Uses RAM memory to . Default is \code{inter}.}

\item{dirds}{(Optional) The directory where the results will be saved in RDS format. Default is \code{rds}.}
}
\value{
A SpatHetero object

\itemize{
\item{hetero A heterogeneity layer}
\item{matrix A Matrix of eigenvalues}
\item{rasters A complete set of heterogeneity layers for each component}
}
}
\description{
The \code{heterog} function is designed to calculate environmental heterogeneity metric from a raster stack dataset.
This function aids in assessing the spatial variation and diversity of environmental variables within the raster data,
providing valuable insights into the heterogeneity of the study area.
}
\examples{
\donttest{
# Case 01: South
path <- system.file("extdata","south", package="heterogen")
south_rast <- terra::rast(list.files(path, full.names = TRUE, 
pattern = '.tif'))

south_het <- heterog(south_rast, parallel = TRUE, 
bandwidth = 0.1, tolerance = 10)
plot(south_het)
}

\donttest{
# Case 02: North
path <- system.file("extdata","north", package="heterogen")
north_rast <- terra::rast(list.files(path, full.names = TRUE, 
pattern = '.tif'))

north_het <- heterog(north_rast, parallel = TRUE,
bandwidth = 0.1, tolerance = 10)
plot(north_het)
}



}
