% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwpca_df_mc.R
\name{gwpca_df_mc}
\alias{gwpca_df_mc}
\title{Perform GWPCA from data.frame with spatial structure.}
\usage{
gwpca_df_mc(
  datadf,
  bandwidth = 0.2,
  tolerance = 5,
  nprocess = 10000,
  parallel = FALSE,
  ncores = 2,
  normalized = FALSE,
  method = "iter",
  dirds = "rds"
)
}
\arguments{
\item{datadf}{The input data matrix for which GWPCA needs to be performed. It should contain numerical values only. Rows represent cells, and columns represent bioclimatic variables.}

\item{bandwidth}{The bandwidth for the spatial weighting function.}

\item{tolerance}{The tolerance for spatial weight computation.}

\item{nprocess}{(Optional) The number of iterations for calculating the principal components. Default is set to 1000.}

\item{parallel}{(Optional) A logical value indicating whether to run the computation in parallel. If \code{TRUE}, multiple cores will be used for processing. Default is \code{FALSE}.}

\item{ncores}{(Optional) The number of cores to be used for parallel computation. Only applicable if \code{parallel} is set to \code{TRUE}. Default is 4.}

\item{normalized}{(Optional) A logical value indicating whether the input data should be normalized before performing GWPCA. Default is \code{FALSE}, meaning the data will not be normalized.
Take in account that core function performs correlation analysis in order to normalize the input variables.}

\item{method}{The method used for GWPCA computation. It can take one of the following values. \code{local} Performs GWPCA locally and will save each iteration on .rds files. Recommended for large-scale data sets.
\code{inter} Uses RAM memory to . Default is \code{inter}.}

\item{dirds}{(Optional) The directory where the results will be saved in RDS format. Default is \code{rds}.}
}
\value{
A matrix of eigenvalues
}
\description{
gwpca_df is an R function that performs Generalized Weighted Principal Component Analysis (GWPCA) on a given dataset.
This function allow to calculate the environmental heterogeneity from data.frame with spatial structure.
}
\examples{
\donttest{
path_csv <- system.file("extdata","south.csv", package="heterogen")
south_csv <- rio::import(path_csv)

# notice: south_csv object contains x,y (lot/lat coordinates)
# and environmental variables
north_het <- gwpca_df_mc(as.matrix(south_csv), parallel = TRUE, 
ncores = 2, bandwidth = 0.1, tolerance = 10)

}

}
