% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_exposure.R
\name{prepare_exposure}
\alias{prepare_exposure}
\title{Prepare exposure data}
\usage{
prepare_exposure(
  poll_grid,
  geo_units,
  population = NULL,
  pop_grid = NULL,
  geo_id_micro = NULL,
  geo_id_macro = NULL,
  bin_width = 0.1
)
}
\arguments{
\item{poll_grid}{\code{SpatRaster} of the pollution concentration data.}

\item{geo_units}{\code{sf} of the geographic units or sub-units.}

\item{population}{\code{Integer vector} of the total population number in each geographic sub-unit.}

\item{pop_grid}{\code{SpatRaster} of the gridded population data.}

\item{geo_id_micro}{\code{Numeric or string vector} of the IDs of the geographic units. Required if \code{pop_grid} is given or if no population data is provided.}

\item{geo_id_macro}{\code{Numeric or string vector} of the higher-level IDs of the geographic units the sub-unit belong to and will be aggregated at. Required if \code{population} is provided.}

\item{bin_width}{\code{Numeric} specifying the width of the population exposure bins.}
}
\value{
This function returns a \code{list} containing:

1) \code{main} (\code{list}) containing the main results as vectors;
\itemize{
 \item \code{geo_id_micro} of \code{geo_id_macro} (\code{string} column) containing the (higher-level) geographic IDs of the assessment
 \item \code{exposure_mean} (\code{numeric} column) containing the (population-weighted) mean exposure
 \item \code{population_total} (\code{integer} column) containing the total population in each geographic unit, if population data was provided
}

2) \code{detailed} (\code{list}) containing detailed (and interim) results.
}
\description{
This function prepares tabular population exposure data compatible with the \code{attribute()} and \code{compare()} functions,
based on gridded pollution concentration data and polygon data representing geographic units.
If population data is provided, the function calculates an average concentration value in each geographic unit
that is weighted with the population number at each location.
If no population data is provided, the function calculates the simple spatial average concentration in each geographic unit.
}
\examples{
# Goal: determine population-weighted mean PM2.5 exposure for several
# neighborhoods of Brussels (Belgium)

path <- system.file("extdata", "exdat_pwm_1.tif", package = "healthiar")
exdat_pwm_1 <- terra::rast(path)

pwm <- prepare_exposure(
  poll_grid = exdat_pwm_1, # Formal class SpatRaster
  geo_units = exdat_pwm_2, # sf of the geographic sub-units
  population = sf::st_drop_geometry(exdat_pwm_2$population), # population per geographic sub-unit
  geo_id_macro = sf::st_drop_geometry(exdat_pwm_2$region) # higher-level IDs to aggregate at
)

pwm$exposure_main # population-weighted mean exposures for the (higher-level) geographic units
}
\author{
Arno Pauwels & Liliana Vazquez Fernandez
}
