% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{peek}
\alias{peek}
\title{Peek into a text file}
\usage{
peek(path, onlyLines = FALSE, n, view = TRUE)
}
\arguments{
\item{path}{Path linking to the text file.}

\item{onlyLines}{Default is \code{FALSE}. If \code{TRUE}, then the first \code{n} lines are directly displayed without formatting.}

\item{n}{Integer. The number of lines to extract from the file. Default is 100 or 5 if \code{onlyLine = TRUE}.}

\item{view}{Logical, default it \code{TRUE}: whether the data should be displayed on the viewer. Only when \code{onlyLines = FALSE}.}
}
\value{
Returns the data invisibly.
}
\description{
This function looks at the first elements of a file, format it into a data frame and displays it. It can also just show the first lines of the file without formatting into a DF.
}
\examples{

# Example with the iris data set
iris_path = tempfile()
fwrite(iris, iris_path)

# The first lines of the text file on viewer
peek(iris_path)

# displaying the first lines:
peek(iris_path, onlyLines = TRUE)

# only getting the data from the first observations
base = peek(iris_path, view = FALSE)
head(base)

}
\seealso{
See \code{\link[hdd]{peek}} to have a convenient look at the first lines of a text file. See \code{\link[hdd]{guess_delim}} to guess the delimiter of a text data set. See \code{\link[hdd]{guess_col_types}} to guess the column types of a text data set.

See \code{\link[hdd]{hdd}}, \code{\link[hdd]{sub-.hdd}} and \code{\link[hdd]{cash-.hdd}} for the extraction and manipulation of out of memory data. For importation of HDD data sets from text files: see \code{\link[hdd]{txt2hdd}}.
}
\author{
Laurent Berge
}
