% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTDmodel-methods.R
\name{MTD-methods}
\alias{MTD-methods}
\title{Methods for objects of class \code{"MTD"}}
\arguments{
\item{x}{An object of class \code{"MTD"} or \code{"summary.MTD"},
depending on the method.}

\item{object}{An object of class \code{"MTD"}.}

\item{X}{A vector or single-column data frame containing an MTD chain sample
(values must be in the model's state space).}

\item{...}{Further arguments passed to or from other methods (ignored).}
}
\value{
\describe{
\item{\code{print.MTD}}{Invisibly returns the \code{"MTD"} object, after
displaying its relevant lag set and state space.}
\item{\code{summary.MTD}}{An object of class \code{"summary.MTD"} with fields:
\code{order}, \code{states}, \code{lags}, \code{indep},
\code{lambdas}, \code{p0} (or \code{NULL}),
\code{P_dim}, and \code{P_head}.}
\item{\code{print.summary.MTD}}{Invisibly returns the
\code{"summary.MTD"} object after printing its contents.}
\item{\code{coef.MTD}}{A list with model parameters:
\code{lambdas}, \code{pj}, and \code{p0}.}
\item{\code{logLik.MTD}}{An object of class \code{"logLik"} with attributes
\code{nobs} (number of transitions) and \code{df} (free parameters),
honoring model constraints such as \code{single_matrix} and the independent
component (\code{indep_part}).}
}
}
\description{
Printing, summarizing, and coefficient-extraction methods for Mixture
Transition Distribution (MTD) model objects.
}
\details{
These methods operate on objects created by \code{\link{MTDmodel}}:
\itemize{
\item \code{print.MTD()} displays a compact summary of the model:
the relevant lag set (shown as negative integers) and the state space.

\item \code{summary.MTD()} collects the key components of the model into
a list (class \code{"summary.MTD"}) containing order, lags, state
space, mixture weights, independent distribution (if present),
the dimension of the global transition matrix \eqn{P}, and a compact
preview of its first rows.

\item \code{print.summary.MTD()} prints that summary in a readable format,
including lambdas, transition matrices \eqn{p_j}, the independent
distribution \eqn{p_0} (if present), and a guide for interpreting the
rows of the global transition matrix \eqn{P}.

\item \code{coef.MTD()} extracts the model parameters as a list with
\code{lambdas}, \code{pj}, and \code{p0}.

\item \code{logLik.MTD()} computes the log-likelihood of a sample under the
model. Since an object of class \code{"MTD"} carries only the model
parameters, a sample \code{X} must be supplied. The method honors
constraints such as \code{single_matrix} and an independent component
(\code{indep_part}), and returns an object of class \code{"logLik"}
with appropriate attributes.
}
}
\examples{
\dontrun{
set.seed(1)
m <- MTDmodel(Lambda = c(1, 3), A = c(0, 1), lam0 = 0.05)

print(m)       # compact display: lags (Z^-) and state space
s <- summary(m)
print(s)

coef(m)        # list(lambdas = ..., pj = ..., p0 = ...)
transitP(m)    # global transition matrix P
pj(m); p0(m); lambdas(m); lags(m); Lambda(m); states(m)

X <- perfectSample(m, N = 400)
logLik(m, X)
}

}
\seealso{
\code{\link{MTDmodel}}, \code{\link{MTDest}},
\code{\link{transitP}}, \code{\link{lambdas}}, \code{\link{pj}},
\code{\link{p0}}, \code{\link{lags}}, \code{\link{Lambda}}, \code{\link{states}},
\code{\link{MTDest-methods}},
\code{\link{oscillation}}, \code{\link{perfectSample}},
\code{\link[stats]{logLik}}
}
