% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hp_palette.R
\name{hp}
\alias{hp}
\alias{hp_pal}
\alias{harrypotter}
\title{Harry Potter Colour Map.}
\usage{
hp(
  n,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "Always",
  house = NULL
)

hp_pal(
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "Always",
  house = NULL
)

harrypotter(
  n,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "Always",
  house = NULL
)
}
\arguments{
\item{n}{The number of colors (\eqn{\ge 1}) to be in the palette.}

\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{begin}{The (corrected) hue in [0,1] at which the hp colormap begins.}

\item{end}{The (corrected) hue in [0,1] at which the hp colormap ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors
are ordered from darkest to lightest. If -1, the order of colors is reversed.}

\item{option}{A character string indicating the colourmap from a option to use.
Four houses are available: "Gryffindor", "Slytherin", "Ravenclaw" and "Hufflepuff".}

\item{house}{Depcreated. Use 'option' instead.}
}
\value{
\code{hp} returns a character vector, \code{cv}, of color hex
codes. This can be used either to create a user-defined color palette for
subsequent graphics by \code{palette(cv)}, a \code{col =} specification in
graphics functions or in \code{par}.
}
\description{
This function creates a vector of \code{n} equally spaced colors along the
'HP colour map' of your selection
}
\details{
Semi-transparent colors (\eqn{0 < alpha < 1}) are supported only on some
devices: see \code{\link[grDevices]{rgb}}.
}
\examples{
library(ggplot2)
library(hexbin)

dat <- data.frame(x = rnorm(1e4), y = rnorm(1e4))
ggplot(dat, aes(x = x, y = y)) +
  geom_hex() +
  coord_fixed() +
  scale_fill_gradientn(colours = hp(128, option = 'Always'))

pal <- hp(256, option = "Ravenclaw")
image(volcano, col = pal)

}
\author{
Alejandro Jiménez Rico \email{aljrico@gmail.com}, \href{https://aljrico.github.io}{Personal Blog}
}
