% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_ml.R
\name{hanr_ml}
\alias{hanr_ml}
\title{Anomaly detector based on ML regression}
\usage{
hanr_ml(model, sw_size = 15)
}
\arguments{
\item{model}{A DALToolbox regression model.}

\item{sw_size}{Integer. Sliding window size.}
}
\value{
\code{hanr_ml} object.
}
\description{
Trains a regression model to forecast the next value from a sliding window
and flags large prediction errors as anomalies. Uses DALToolbox regressors.

A set of preconfigured regression methods are described at
\url{https://cefet-rj-dal.github.io/daltoolbox/} (e.g., \code{ts_elm}, \code{ts_conv1d},
\code{ts_lstm}, \code{ts_mlp}, \code{ts_rf}, \code{ts_svm}).
}
\examples{
library(daltoolbox)
library(tspredit)

# Load anomaly example data
data(examples_anomalies)

# Use a simple example
dataset <- examples_anomalies$simple
head(dataset)

# Configure a time series regression model
model <- hanr_ml(tspredit::ts_elm(tspredit::ts_norm_gminmax(),
                   input_size=4, nhid=3, actfun="purelin"))

# Fit the model
model <- daltoolbox::fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected anomalies
print(detection[(detection$event),])

}
\references{
\itemize{
\item Hyndman RJ, Athanasopoulos G (2021). Forecasting: Principles and Practice. OTexts.
\item Goodfellow I, Bengio Y, Courville A (2016). Deep Learning. MIT Press.
}
}
