% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_variants.R
\name{get_variants_by_cytogenetic_band}
\alias{get_variants_by_cytogenetic_band}
\title{Get GWAS Catalog variants by cytogenetic band.}
\usage{
get_variants_by_cytogenetic_band(
  cytogenetic_band = NULL,
  verbose = FALSE,
  warnings = TRUE,
  page_size = 20L
)
}
\arguments{
\item{cytogenetic_band}{A \code{character} vector of cytogenetic bands of the
form \code{'1p36.11'}}

\item{verbose}{Whether the function should be verbose about the different
queries or not.}

\item{warnings}{Whether to print warnings.}

\item{page_size}{An integer scalar indicating the
\href{https://www.ebi.ac.uk/gwas/rest/docs/api#_paging_resources}{page}
value to be used in the JSON requests, can be between \code{1} and
\code{1000}.}
}
\value{
A \linkS4class{variants} object.
}
\description{
Gets variants that are mapped onto specific regions as specified by
cytogenetic bands. See the dataframe
\code{\link[gwasrapidd]{cytogenetic_bands}} for more information on possible
values.
}
\keyword{internal}
