% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt_gtfs.R
\name{as_dt_gtfs}
\alias{as_dt_gtfs}
\alias{as_dt_gtfs.tidygtfs}
\alias{as_dt_gtfs.gtfs}
\alias{as_dt_gtfs.list}
\title{Coerce lists and GTFS objects from other packages into gtfstools-compatible
GTFS objects}
\usage{
as_dt_gtfs(gtfs, ...)

\method{as_dt_gtfs}{tidygtfs}(gtfs, calculate_distance = TRUE, ...)

\method{as_dt_gtfs}{gtfs}(gtfs, ...)

\method{as_dt_gtfs}{list}(gtfs, ...)
}
\arguments{
\item{gtfs}{The object that should be coerced to a \code{dt_gtfs}.}

\item{...}{Ignored.}

\item{calculate_distance}{A logical. Passed to \code{\link[=convert_sf_to_shapes]{convert_sf_to_shapes()}},
which only affects the output when the object to be converted includes a
\code{shapes} element. Controls whether this function, used to convert a
\verb{LINESTRING sf} into a GTFS \code{shapes} table, should calculate and populate
the \code{shape_dist_traveled} column. This column is used to describe the
distance along the shape from each one of its points to its first point.
Defaults to \code{TRUE}.}
}
\value{
A \code{dt_gtfs} GTFS object.
}
\description{
Coerces an existing object, such as a \code{list} or a GTFS object created from
other packages (\code{{tidytransit}} and \code{{gtfsio}}, for example) into a
gtfstools-compatible GTFS object - i.e. one whose internal tables are
represented with \code{data.table}s and whose fields are formatted like the fields
of a feed read with \code{\link[=read_gtfs]{read_gtfs()}}.

\code{as_dt_gtfs()} is an S3 generic, with methods for:
\itemize{
\item \code{tidygtfs}: the class of GTFS objects read with \code{\link[tidytransit:read_gtfs]{tidytransit::read_gtfs()}}.
This method converts all \code{tibble}s to \code{data.table}s and convert time columns,
represented as \code{hms} objects in a \code{tidygtfs}, to strings in the \code{"HH:MM:SS"}
format.
\item \code{gtfs}: the class of GTFS objects read with \code{\link[gtfsio:import_gtfs]{gtfsio::import_gtfs()}}. This
method convert all date fields, represented as \code{integer}s in \code{{gtfsio}}'s
representation, to \code{Date} objects.
\item \code{list}: this method tries to convert the elements of a list into
\code{data.table}s. Please note that all list elements must inherit from
\code{data.frame} and must be named. This method does not try not convert fields
to the representation used in \code{{gtfstools}}, as it does not have any
information on how they are formatted in the first place.
}
}
\examples{
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")

gtfsio_gtfs <- gtfsio::import_gtfs(data_path)
class(gtfsio_gtfs)

gtfstools_gtfs <- as_dt_gtfs(gtfsio_gtfs)
class(gtfstools_gtfs)

gtfs_like_list <- unclass(gtfsio_gtfs)
class(gtfs_like_list)

gtfstools_gtfs <- as_dt_gtfs(gtfs_like_list)
class(gtfstools_gtfs)

}
