% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{plot.fut}
\alias{plot.fut}
\title{Plot the planned futility boundaries}
\usage{
\method{plot}{fut}(
  x,
  scale = "z",
  add = FALSE,
  lty = 8,
  xlab = "Info Time",
  ylab = "z score",
  type = "b",
  pch = 1,
  cex = 1,
  main = "Futility Boundary for the Planned Test",
  xlim = c(0, 1.1),
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{An object returned by \code{\link{fut}}.}

\item{scale}{\code{"z"}: plot z-values; \code{"b"}: plot B-values.}

\item{add}{If TRUE, the curve will be overlaid on an existing plot; otherwise,
a separate plot will be constructed.}

\item{lty}{Line type for the segments connecting the z-/B-value points.}

\item{xlab}{A label for the x axis, defaults to a description of x.}

\item{ylab}{A label for the y axis, defaults to a description of y.}

\item{type}{Plot type. \code{"l"}: only line segments; \code{"p"}: only z-/B-value points;
\code{"b"}: both.}

\item{pch}{Point types for the z-/B-values.}

\item{cex}{Point size.}

\item{main}{A main title for the plot.}

\item{xlim}{The x limits of the plot.}

\item{ylim}{The y limits of the plot.}

\item{...}{Other arguments that can be passed to the underlying \code{plot} method.}
}
\value{
No return value, called for side effects.
}
\description{
Plot the planned futility boundaries in B- or z-values as a function
of information time.
}
\examples{
# see example for fut
}
\seealso{
\code{\link{fut}}, \code{\link{summary.fut}}, \code{\link{powerplot}}.
}
\keyword{fut}
