% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Surv.R
\name{summary.Surv}
\alias{summary.Surv}
\title{Summary Information of \link[survival]{Surv} Object}
\usage{
\method{summary}{Surv}(object, ...)
}
\arguments{
\item{object}{a \link[survival]{Surv} object}

\item{...}{additional parameters, currently of no use}
}
\value{
The function \code{\link[=summary.Surv]{summary.Surv()}} returns a \link[base]{character} \link[base]{vector}.
}
\description{
The missing \code{S3} method of the generic function \link[base]{summary} for \link[survival]{Surv} object.
}
\note{
Without function \code{\link[=summary.Surv]{summary.Surv()}},
the \code{S3} generic function \link[base]{summary} dispatches to function \link[base]{summary.default}
if the input is a \link[survival]{Surv} object.
}
\examples{
aml2 = survival::aml |>
 within.data.frame(expr = {
  os = survival::Surv(time = time, event = status)
  time = status = NULL
 })
summary(aml2$os)
summary(aml2)

heart2 = survival::heart |>
 within.data.frame(expr = {
  os = survival::Surv(time = start, time2 = stop, event = event)
  start = stop = event = NULL
 })
summary(heart2$os)
summary(heart2)

}
\seealso{
\link[base]{summary.factor}
}
\keyword{internal}
