% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans.R
\name{kmeans_etc}
\alias{kmeans_etc}
\alias{kmeans.ppp}
\alias{kmeans.ppplist}
\alias{kmeans.hyperframe}
\title{Pseudo \code{S3} Methods based on \link[stats]{kmeans}}
\usage{
kmeans.ppp(
  x,
  formula,
  centers = as.integer(ceiling((x[["n"]]/clusterSize))),
  clusterSize,
  ...
)

kmeans.ppplist(x, ...)

kmeans.hyperframe(x, ...)
}
\arguments{
\item{x}{see \strong{Usage}}

\item{formula}{\link[stats]{formula}}

\item{centers}{\link[base]{integer} scalar, number of clusters \eqn{k}, see function \link[stats]{kmeans}}

\item{clusterSize}{\link[base]{integer} scalar, number of points per cluster}

\item{...}{additional parameters of the function \link[stats]{kmeans}}
}
\value{
The function \code{\link[=kmeans.ppp]{kmeans.ppp()}} returns an object of class \code{'pppkm'},
which inherits from \link[spatstat.geom]{ppp.object}.

The function \code{\link[=kmeans.ppplist]{kmeans.ppplist()}} returns an object of class \code{'pppkmlist'},
which inherits from \code{'ppplist'}.
}
\description{
Pseudo \code{S3} Methods based on \link[stats]{kmeans}
}
\references{
\url{https://tingtingzhan.quarto.pub/groupedhyperframe/topics.html}
}
\keyword{internal}
