% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AOQL_grab_B.R
\name{AOQL_grab_B}
\alias{AOQL_grab_B}
\title{Construction of  AOQ curve and calculate AOQL value based on average microbial counts}
\usage{
AOQL_grab_B(c, r, t, distribution,llim, K, m, sd)
}
\arguments{
\item{c}{acceptance number}

\item{r}{number of primary increments in a grab sample or grab sample size}

\item{t}{number of grab samples}

\item{distribution}{what suitable microbiological distribution we have used such as  \code{'Poisson gamma'} or \code{'Lognormal'}or \code{'Poisson lognormal'}}

\item{llim}{the upper limit for graphing the arithmetic mean of cell count}

\item{K}{dispersion parameter of the Poisson gamma distribution (default value 0.25)}

\item{m}{microbiological limit with default value zero, generally expressed as number of microorganisms in specific sample weight}

\item{sd}{standard deviation of the lognormal and Poisson-lognormal distributions on the log10 scale (default value 0.8)}
}
\value{
AOQ curve and AOQL value based on average microbial counts
}
\description{
\code{\link{AOQL_grab_B}} provides the AOQ curve and calculates AOQL value based on average microbial counts.
}
\details{
Since \eqn{P_a} is the probability of acceptance, \eqn{\lambda} is the arithmetic mean of cell count and the outgoing contaminated arithmetic mean of cell count of primary increments is given by \eqn{AOQ} as the product \eqn{\lambda P_a}.
          The quantity \eqn{AOQL} is defined as the maximum proportion of outgoing contaminated primary increments and is given by \deqn{AOQL ={\max_{\lambda \geq 0}}{\lambda P_a}}
}
\examples{
  c <-  0
  r <-  25
  t <-  30
  distribution <- 'Poisson lognormal'
  llim <- 0.20
  AOQL_grab_B(c, r, t, distribution, llim)
}
\seealso{
\link{prob_accept}
}
