% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packages.R
\name{gpo_package_granules}
\alias{gpo_package_granules}
\title{Given a GPO package id, get a list of granules associated with that package.}
\usage{
gpo_package_granules(
  package_id,
  page_size = 20,
  offset_mark = "*",
  md5 = NULL,
  granule_class = NULL
)
}
\arguments{
\item{package_id}{String. The Package Id. Ex: CREC-2018-01-04}

\item{page_size}{Integer. The number of records to retrieve per request. Defaults to 20.}

\item{offset_mark}{Indicates starting record for a given request.}

\item{md5}{String. md5 hash value of the html content file - can be used to identify changes
in individual granules for the HOB and CRI collections.}

\item{granule_class}{String. Filter the results by overarching collection-specific categories.
Varies by collection.}
}
\value{
A tibble
}
\description{
The \code{offset} param provide by the API is not supported. GovInfo documentation indicates that it was to
be deprecated in December, 2022, and though it is still available through the API, the \code{offsetMark} parameter
is supported instead. Parameter descriptions are adapted from
\href{https://www.govinfo.gov/}{GovInfo} API documentation.
}
\examples{
\dontshow{if (govinfoR::has_govinfo_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

gpo_package_granules("CREC-2018-01-04")
\dontshow{\}) # examplesIf}
}
