% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measurement_protocol.R
\name{ga_mp_send}
\alias{ga_mp_send}
\alias{ga_mp_connection}
\title{Make a Measurement Protocol v2 request}
\usage{
ga_mp_send(
  events,
  client_id,
  connection,
  user_id = NULL,
  debug_call = FALSE,
  timestamp_micros = NULL,
  user_properties = NULL,
  non_personalized_ads = TRUE
)

ga_mp_connection(
  measurement_id,
  api_secret = Sys.getenv("MP_SECRET"),
  endpoint = NULL,
  preview_header = NULL
)
}
\arguments{
\item{events}{The events to send}

\item{client_id}{The client_id to associate with the event}

\item{connection}{The connection details created by \link{ga_mp_connection}}

\item{user_id}{Optional. Unique id for the user}

\item{debug_call}{Send hits to the Google debug endpoint to validate hits.}

\item{timestamp_micros}{Optional. A Unix timestamp (in microseconds) for the time to associate with the event.}

\item{user_properties}{Optional. The user properties for the measurement sent in as a named list.}

\item{non_personalized_ads}{Optional. Set to true to indicate these events should not be used for personalized ads.}

\item{measurement_id}{The measurement ID associated with a stream}

\item{api_secret}{The secret generated in the GA4 UI - by default will look for environment arg \code{MP_SECRET}}

\item{endpoint}{If NULL will use Google default, otherwise set to the URL of your Measurement Protocol custom endpoint}

\item{preview_header}{Only needed for custom endpoints. The \code{X-Gtm-Server-Preview} HTTP Header found in your GTM debugger}
}
\value{
\code{TRUE} if successful, if \code{debug_call=TRUE} then validation messages if not a valid hit.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Create a server side call to Google Analytics 4 via its Measurement Protocol

Use \link{ga_mp_connection} to set up the Measurement Protocol connections to pass to \link{ga_mp_send}.  If using Google Tag Manager Server-Side, you can also set up a custom endpoint.
}
\details{
Create an API secret via \verb{Admin > Data Streams > choose your stream > Measurement Protocol > Create}

To see event parameters, create custom fields in your GA4 account first, to see them in your reports 24hrs after you send them in with this function via \verb{Custom definitions > Create custom dimensions} - \verb{dimension name} will be how it looks like in the reports, \verb{event parameter} will be the parameter you have sent in with the event.

\code{user_id} can be used for \href{https://support.google.com/analytics/answer/9213390}{cross-platform analysis}

\code{timestamp_micros} should only be set to record events that happened in the past. This value can be overridden via user_property or event timestamps. Events can be backdated up to 48 hours. Note microseconds, not milliseconds.

\code{user_properties} - describe segments of your user base, such as language preference or geographic location.  See \href{https://developers.google.com/analytics/devguides/collection/protocol/ga4/user-properties?client_type=gtag}{User properties}

Ensure you also have user permission as specified in the \href{https://developers.google.com/analytics/devguides/collection/protocol/ga4/policy}{feature policy}

Invalid events are silently rejected with a 204 response, so use \code{debug_call=TRUE} to validate your events first.
}
\examples{
# preferably set this in .Renviron
Sys.setenv(MP_SECRET="MY_SECRET")

# your GA4 settings
my_measurement_id <- "G-1234"

my_connection <- ga_mp_connection(my_measurement_id)

a_client_id <- 123.456
event <- ga_mp_event("an_event")

\dontrun{
#' ga_mp_send(event, a_client_id, my_connection, debug_call = TRUE)

# multiple events at same time in a batch
another <- ga_mp_event("another_event")

ga_mp_send(list(event, another), 
           a_client_id, 
           my_connection,
           debug_call = TRUE)
           
# you can see sent events in the real-time reports
my_property_id <- 206670707
ga_data(my_property_id, 
        dimensions = "eventName", 
        metrics = "eventCount", 
        dim_filters = ga_data_filter(
           eventName == c("an_event","another_event")),
        realtime = TRUE)

}

# custom GTM server side endpoint
my_custom_connection <- ga_mp_connection(
   my_measurement_id,
   endpoint = "https://gtm.example.com",
   preview_header = "ZW52LTV8OWdPOExNWFkYjA0Njk4NmQ="
 )
 
}
\seealso{
\href{https://developers.google.com/analytics/devguides/collection/protocol/ga4}{Measurement Protocol (Google Analytics 4)}

Other Measurement Protocol functions: 
\code{\link{ga_mp_cid}()},
\code{\link{ga_mp_event}()},
\code{\link{ga_mp_event_item}()}
}
\concept{Measurement Protocol functions}
