% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertztrunc_simu.R
\name{gompertztrunc_simu}
\alias{gompertztrunc_simu}
\title{Simulate Gompertzian death distribution}
\usage{
gompertztrunc_simu(
  n,
  formula,
  coefs,
  dummy = NULL,
  sigma = NULL,
  seed = NULL,
  a0 = 10^-4,
  b = 1/10,
  verbose = FALSE
)
}
\arguments{
\item{n}{sample size}

\item{formula}{estimation formula}

\item{coefs}{named vectors of coefficients and corresponding true values}

\item{dummy}{vector flags for each coefficient}

\item{sigma}{standard deviation for each variable}

\item{seed}{random seed to duplicate data}

\item{a0}{Gompertz alpha parameter}

\item{b}{Gompertz b parameter}

\item{verbose}{print internal check if true}
}
\value{
dataframe of simulated death ages and covariate values
}
\description{
Simulate Gompertzian death distribution
}
\examples{
gompertztrunc_simu(n=1000, formula = death_age ~ sex + ambient_temp,
coefs = c('sex'=-0.8, 'ambient_temp'=0.3), dummy=c(TRUE,FALSE))

}
