% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy.R
\name{xvErrorMeasures}
\alias{xvErrorMeasures}
\alias{xvErrorMeasures.data.frame}
\alias{xvErrorMeasures.DataFrameStack}
\title{Cross-validation errror measures}
\usage{
xvErrorMeasures(x, ...)

\method{xvErrorMeasures}{data.frame}(
  x,
  observed = x$observed,
  output = "MSDR1",
  univariate = length(dim(observed)) == 0,
  ...
)

\method{xvErrorMeasures}{DataFrameStack}(
  x,
  observed,
  output = "ME",
  univariate = length(dim(observed)) == 0,
  ...
)
}
\arguments{
\item{x}{a dataset of predictions (if \code{x} is of class "data.frame") or simulations
(if \code{x} is of class "DataFrameStack")}

\item{...}{extra arguments for generic functionality}

\item{observed}{a vector (if univariate) or a matrix/dataset of true values}

\item{output}{which output do you want? a vector of one or several of  c("ME","MSE","MSDR","MSDR1","MSDR2","Mahalanobis")}

\item{univariate}{logical control, typically you should not touch it}
}
\value{
If just some of c("ME","MSE","MSDR","MSDR1","MSDR2") are requested, the output is a named
vector with the desired quantities. If only "Mahalanobis" is requested, the output is a vector
of Mahalanobis square errors. If you mix up things and ask for "Mahalanobis" and some of
the quantities mentioned above, the result will be a named list with the requested quantities.
(NOTE: some options are not available for \code{x} a "DataFrameStack")
}
\description{
Compute one or more error measures from cross-validation output
}
\details{
"ME" stands for \emph{mean error} (average of the differences between true values and predicted values),
"MSE" stands for \emph{mean square error} (average of the square differences between true values and predicted values),
and "MSDR" for \emph{mean squared deviation ratio} (average of the square between true values and predicted values
each normalized by its kriging variance). These quantities are classically used in evaluating
output results of validation exercises of one single variable.
For multivariate cases, "ME" (a vector) and "MSE" (a scalar) work as well,
while two different definitions of a multivariate
mean squared deviation ratio can be given:
\itemize{
\item "MSDR1" is the average Mahalanobis square error (see \code{\link[=accuracy]{accuracy()}} for explanations)
\item "MSDR2" is the average univariate "MSDR" over all variables.
}
}
\section{Functions}{
\itemize{
\item \code{xvErrorMeasures}: Cross-validation errror measures

\item \code{xvErrorMeasures.DataFrameStack}: Cross-validation errror measures
}}

\seealso{
Other accuracy functions: 
\code{\link{accuracy}()},
\code{\link{mean.accuracy}()},
\code{\link{plot.accuracy}()},
\code{\link{precision}()},
\code{\link{validate}()},
\code{\link{xvErrorMeasures.default}()}
}
\concept{accuracy functions}
