% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmAnisotropy.R
\name{AnisotropyRangeMatrix}
\alias{AnisotropyRangeMatrix}
\alias{as.AnisotropyRangeMatrix.AnisotropyScaling}
\title{Force a matrix to be anisotropy range matrix,}
\usage{
AnisotropyRangeMatrix(x, checkValidity = TRUE)

\method{as.AnisotropyRangeMatrix}{AnisotropyScaling}(x)
}
\arguments{
\item{x}{matrix simmetric positive definite (i.e. M above)}

\item{checkValidity}{boolean, should validity be checked?}
}
\value{
the same matrix with a class attribute
}
\description{
Force a matrix M to be considered an anisotropy range matrix, i.e
with ranges and orientations,
such that \eqn{u = sqrt(h' * M^{-1} * h)} allows to use an isotropic
variogram.
}
\section{Methods (by generic)}{
\itemize{
\item \code{as.AnisotropyRangeMatrix}: Convert from AnisotropyScaling
}}

\seealso{
Other anisotropy: 
\code{\link{AnisotropyScaling}()},
\code{\link{anis_GSLIBpar2A}()},
\code{\link{as.AnisotropyRangeMatrix}()},
\code{\link{as.AnisotropyScaling}()},
\code{\link{is.anisotropySpecification}()}
}
\concept{anisotropy}
