% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmtlp-package.R, R/glmtlp.R
\docType{package}
\name{glmtlp}
\alias{glmtlp-package}
\alias{glmtlp}
\title{glmtlp: A package for fitting a GLM with l0, l1, and tlp regularization.}
\usage{
glmtlp(
  X,
  y,
  family = c("gaussian", "binomial"),
  penalty = c("l0", "l1", "tlp"),
  nlambda = ifelse(penalty == "l0", 50, 100),
  lambda.min.ratio = ifelse(nobs < nvars, 0.05, 0.001),
  lambda = NULL,
  kappa = NULL,
  tau = 0.3 * sqrt(log(nvars)/nobs),
  delta = 2,
  tol = 1e-04,
  weights = NULL,
  penalty.factor = rep(1, nvars),
  standardize = FALSE,
  dc.maxit = 20,
  cd.maxit = 10000,
  nr.maxit = 20,
  ...
)
}
\arguments{
\item{X}{Input matrix, of dimension \code{nobs} x \code{nvars};
each row is  an observation vector.}

\item{y}{Response variable, of length \code{nobs}. For \code{family="gaussian"},
it should be quantitative; for \code{family="binomial"}, it should be either
a factor with two levels or a binary vector.}

\item{family}{A character string representing one of the built-in families.
See Details section below.}

\item{penalty}{A character string representing one of the built-in penalties.
\code{"l0"} represents the \eqn{L_0} penalty, \code{"l1"} represents the
lasso-type penalty (\eqn{L_1} penalty), and \code{"tlp"} represents the
truncated lasso penalty.}

\item{nlambda}{The number of \code{lambda} values. Default is 100.}

\item{lambda.min.ratio}{The smallest value for \code{lambda}, as a fraction of
\code{lambda.max}, the smallest value for which all coefficients are zero.
The default depends on the sample size \code{nobs} relative to the number
of variables \code{nvars}. If \code{nobs > nvars}, the default is
\code{0.0001}, and if \code{nobs < nvars}, the default is \code{0.01}.}

\item{lambda}{A user-supplied \code{lambda} sequence. Typically, users should let
the program compute its own \code{lambda} sequence based on
\code{nlambda} and \code{lambda.min.ratio}. Supplying a value of
\code{lambda} will override this. WARNING: please use this option with care.
\code{glmtlp} relies on warms starts for speed, and it's often faster to
fit a whole path than a single fit. Therefore, provide a decreasing sequence
of \code{lambda} values if you want to use this option. Also, when
\code{penalty = 'l0'}, it is not recommended for the users to supply
this parameter.}

\item{kappa}{A user-supplied \code{kappa} sequence. Typically, users should
let the program compute its own \code{kappa} sequence based on \code{nvars}
and \code{nobs}. This sequence is used when \code{penalty = 'l0'}.}

\item{tau}{A tuning parameter used in the TLP-penalized regression models.
Default is  \code{0.3 * sqrt(log(nvars)/nobs)}.}

\item{delta}{A tuning parameter used in the coordinate majorization descent
algorithm. See Yang, Y., & Zou, H. (2014) in the reference for more detail.}

\item{tol}{Tolerance level for all iterative optimization algorithms.}

\item{weights}{Observation weights. Default is 1 for each observation.}

\item{penalty.factor}{Separate penalty factors applied to each
coefficient, which allows for differential shrinkage. Default is 1
for all variables.}

\item{standardize}{Logical. Whether or not standardize the input matrix
\code{X}; default is \code{TRUE}.}

\item{dc.maxit}{Maximum number of iterations for the DC (Difference of
Convex Functions) programming; default is 20.}

\item{cd.maxit}{Maximum number of iterations for the coordinate descent
algorithm; default is 10^4.}

\item{nr.maxit}{Maximum number of iterations for the Newton-Raphson method;
default is 500.}

\item{...}{Additional arguments.}
}
\value{
An object with S3 class \code{"glmtlp"}.

\item{beta}{a \code{nvars x length(kappa)} matrix of
  coefficients when \code{penalty = 'l0'}; or a \code{nvars x length(lambda)}
  matrix of coefficients when \code{penalty = c('l1', 'tlp')}.}
\item{call}{the call that produces this object.}
\item{family}{the distribution family used in the model fitting.}
\item{intercept}{the intercept vector, of \code{length(kappa)} when
  \code{penalty = 'l0'} or \code{length(lambda)} when
  \code{penalty = c('l1', 'tlp')}.}
\item{lambda}{the actual sequence of \code{lambda} values used. Note that
  the length may be smaller than the provided \code{nlambda} due to removal
  of saturated values.}
\item{penalty}{the penalty type in the model fitting.}
\item{penalty.factor}{the penalty factor for each coefficient used in the model fitting.}
\item{tau}{the tuning parameter used in the model fitting, available when
  \code{penalty = 'tlp'}.}
}
\description{
The package provides 3 penalties: l0, l1, and tlp and 3 distribution families: 
  gaussian, binomial, and poisson.

Fit generalized linear models via penalized maximum likelihood. The
  regularization path is computed for the l0, lasso, or truncated lasso
  penalty at a grid of values for the regularization parameter \code{lambda}
  or \code{kappa}. Fits linear and logistic regression models.
}
\details{
The sequence of models indexed by \code{lambda} (when \code{penalty = c('l1', 'tlp')})
  or \code{kappa} (when \code{penalty = 'l0'}) is fit by the coordinate
  descent algorithm.

  The objective function for the \code{"gaussian"} family is:
  \deqn{1/2 RSS/nobs + \lambda*penalty,} and for the other models it is:
  \deqn{-loglik/nobs + \lambda*penalty.}
  Also note that, for \code{"gaussian"}, \code{glmtlp} standardizes y to
  have unit variance (using 1/(n-1) formula).

  ## Details on \code{family} option

  \code{glmtlp} currently only supports built-in families, which are specified by a
  character string. For all families, the returned object is a regularization
  path for fitting the generalized linear regression models, by maximizing the
  corresponding penalized log-likelihood. \code{glmtlp(..., family="binomial")}
  fits a traditional logistic regression model for the log-odds.

  ## Details on \code{penalty} option

  The built-in penalties are specified by a character string. For \code{l0}
  penalty, \code{kappa} sequence is used for generating the regularization
  path, while for \code{l1} and \code{tlp} penalty, \code{lambda} sequence
  is used for generating the regularization path.
}
\section{glmtlp functions}{

`glmtlp()`, `cv.glmtlp()`
}

\examples{

# Gaussian
X <- matrix(rnorm(100 * 20), 100, 20)
y <- rnorm(100)
fit1 <- glmtlp(X, y, family = "gaussian", penalty = "l0")
fit2 <- glmtlp(X, y, family = "gaussian", penalty = "l1")
fit3 <- glmtlp(X, y, family = "gaussian", penalty = "tlp")

# Binomial

X <- matrix(rnorm(100 * 20), 100, 20)
y <- sample(c(0, 1), 100, replace = TRUE)
fit <- glmtlp(X, y, family = "binomial", penalty = "l1")
}
\references{
Shen, X., Pan, W., & Zhu, Y. (2012).
  \emph{Likelihood-based selection and sharp parameter estimation.
  Journal of the American Statistical Association, 107(497), 223-232.}
  \cr Shen, X., Pan, W., Zhu, Y., & Zhou, H. (2013).
  \emph{On constrained and regularized high-dimensional regression.
  Annals of the Institute of Statistical Mathematics, 65(5), 807-832.}
  \cr Li, C., Shen, X., & Pan, W. (2021).
  \emph{Inference for a Large Directed Graphical Model with Interventions.
  arXiv preprint arXiv:2110.03805.}
  \cr Yang, Y., & Zou, H. (2014).
  \emph{A coordinate majorization descent algorithm for l1 penalized learning.
  Journal of Statistical Computation and Simulation, 84(1), 84-95.}
  \cr Two R package Github: \emph{ncvreg} and \emph{glmnet}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://yuyangyy.com/glmtlp/}
}


\code{print}, \code{predict}, \code{coef} and \code{plot} methods,
and the \code{cv.glmtlp} function.
}
\author{
\strong{Maintainer}: Yu Yang \email{yuyang.stat@gmail.com} (\href{https://orcid.org/0000-0001-7355-6702}{ORCID}) [copyright holder]

Authors:
\itemize{
  \item Chunlin Li \email{chunlin@iastate.edu} (\href{https://orcid.org/0000-0003-2989-8785}{ORCID}) [copyright holder]
  \item Chong Wu (\href{https://orcid.org/0000-0002-8400-1785}{ORCID}) [copyright holder]
}

Other contributors:
\itemize{
  \item Xiaotong Shen [thesis advisor, copyright holder]
  \item Wei Pan [thesis advisor, copyright holder]
}


Chunlin Li, Yu Yang, Chong Wu
  \cr Maintainer: Yu Yang \email{yang6367@umn.edu}
}
\keyword{internal}
\keyword{models}
\keyword{regression}
