% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cv.glmnetr_250503.R
\name{plot.glmnetr}
\alias{plot.glmnetr}
\title{Plot the relaxed lasso coefficients.}
\usage{
\method{plot}{glmnetr}(
  x,
  type = "lasso",
  alpha = NULL,
  gamma = NULL,
  lambda.lo = NULL,
  title = NULL,
  comment = TRUE,
  ...
)
}
\arguments{
\item{x}{A nested.glmnetr output object.}

\item{type}{one of c("lasso", "elastic", "ridge") to plot the deviance 
curves of the respective model fit. Default is "lasso".}

\item{alpha}{A specific level of alpha for plotting. By default alpha.min
will be used such that the triplet (alpha.min, gamma.min, lambda.min) 
minimizes the model deviance.}

\item{gamma}{A specific level of gamma for plotting.  By default gamma.min will 
be used such that the pair (gamma.min, lambda.min) minimzes the model 
deviance.}

\item{lambda.lo}{A lower limit of lambda for plotting.}

\item{title}{A title for the plot}

\item{comment}{Default of TRUE to write to console information on gamma and 
lambda selected for output. FALSE will suppress this write to console.}

\item{...}{Additional arguments passed to the plot function.}
}
\value{
This program returns a plot to the graphics window, and may provide 
some numerical information to the R Console.  If gamma is not specified, 
then the gamma.min from
the deviance minimizing (lambda.min, gamma.min) pair will be used, and the
minimizing lambda.min will be indicated by a vertical line.  Also, if one 
specifies gamma=0, the lambda which minimizes deviance for the restricted 
set of models where gamma=0 will indicated by a vertical line.
}
\description{
Plot the relaxed lasso, elastic net or ridge model coefficients from a nested.glmnetr() output object.
One may specify a value for gamma.  If gamma is unspecified (NULL), then 
the plot will be for the gamma which minimizes loss.
}
\examples{
\donttest{
set.seed(82545037)
sim.data=glmnetr.simdata(nrows=200, ncols=100, beta=NULL)
xs=sim.data$xs 
yt=sim.data$yt
yg=sim.data$yt
event=sim.data$event
glmnetr.fit = nested.glmnetr(xs, start=NULL, yg, event=event, family="gaussian",
  resample=0, folds_n=4)
plot(glmnetr.fit, type="lasso")
}

}
\seealso{
\code{\link{plot.cv.glmnetr}} , \code{\link{plot.nested.glmnetr}}
}
